// --- CUSTOMER MANAGER MODULE ---
// Contains all logic for managing the selected customer
// -----------------------------

// Global selectors
// const $customerId = window.$customerId; // Removed to avoid redeclaration
// const $selectedCustomerName = window.$selectedCustomerName; // Removed to avoid redeclaration
// const $selectedCustomerIndicator = window.$selectedCustomerIndicator; // Removed to avoid redeclaration
// const $guestCustomerIndicator = window.$guestCustomerIndicator; // Removed to avoid redeclaration

loycart.customerManager = {

    addSelectedCustomerToCart: function (customerId, customerName) {
        window.$customerId.val(customerId);
        window.$selectedCustomerName.text(customerName);

        window.$guestCustomerIndicator.hide();
        window.$selectedCustomerIndicator.css('display', 'flex');
        jQuery('#customer-cart-indicator').removeClass('is-guest');

        showNotification(strings.customerSelected.replace('%s', customerName), 'success');
        loycart.cartManager.getCartTotalsFromServer();
        loycart.cartManager.debouncedSaveCartToServer();

        // Fetch and display store credit for this customer (if enabled)
        if (typeof window.api_getStoreCredit === 'function') {
            window.api_getStoreCredit(customerId)
                .done(function(response) {
                    if (response && response.success && response.data) {
                        const amount = parseFloat(response.data.amount) || 0;
                        const code = response.data.code || '';
                        window.storeCredit = { amount: amount, code: code };
                        jQuery('#store-credit-balance').text(formatPrice(Math.abs(amount)));
                        jQuery('#store-credit-indicator').show();
                        if (loycart.couponManager && typeof loycart.couponManager.updateCreditPrompt === 'function') {
                            loycart.couponManager.updateCreditPrompt();
                        }
                    } else {
                        window.storeCredit = { amount: 0, code: '' };
                        jQuery('#store-credit-balance').text(formatPrice(0));
                        jQuery('#store-credit-indicator').show();
                        if (loycart.couponManager && typeof loycart.couponManager.updateCreditPrompt === 'function') {
                            loycart.couponManager.updateCreditPrompt();
                        }
                    }
                })
                .fail(function() {
                    jQuery('#store-credit-indicator').hide();
                });
        }
    },

    removeCustomerFromCartState: function() {

        window.$customerId.val('0');
        window.$selectedCustomerName.text('');

        window.$selectedCustomerIndicator.hide();
        window.$guestCustomerIndicator.show();
        jQuery('#customer-cart-indicator').addClass('is-guest');


        window.selectedShipping = {
            id: null,
            cost: 0,
            label: ''
        };

        // Clear store credit indicator
        window.storeCredit = { amount: 0, code: '' };
        jQuery('#store-credit-indicator').hide();

        if (loycart.couponManager && typeof loycart.couponManager.updateCreditPrompt === 'function') {
            loycart.couponManager.updateCreditPrompt();
        }


        loycart.cartManager.getCartTotalsFromServer();
        loycart.shippingManager.updateShippingCallToAction();
        loycart.cartManager.debouncedSaveCartToServer();
    }
};
// --- END CUSTOMER MANAGER MODULE ---