
(function($) {
    window.api_saveCartToServer = function(stateToSave) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_save_data',
                nonce: loycartPOS.nonce,
                cart_state: JSON.stringify(stateToSave)
            },
            success: function(response) {
                if (!response.success) {
                    loycart.logger.error("Error saving cart state to server:", response.data);
                }
            },
            error: function(jqXHR) {
                loycart.logger.error("AJAX error saving cart state:", jqXHR.responseText);
            }
        });
    }

    window.api_loadCartFromServer = function() {
        return $.ajax({ 
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_load_data',
                nonce: loycartPOS.nonce
            }
        });
    }

    window.api_clearCartOnServer = function() {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_clear_data',
                nonce: loycartPOS.nonce
            },
            success: function(response) {
                if (!response.success) {
                    loycart.logger.error("Error clearing cart state on server:", response.data);
                }
            },
            error: function(jqXHR) {
                loycart.logger.error("AJAX error clearing cart state:", jqXHR.responseText);
            }
        });
    }



    window.api_loadProducts = function(category_id, search, page, per_page, sort) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_get_products',
                nonce: loycartPOS.nonce,
                category_id: category_id,
                search: search,
                page: page,
                per_page: per_page,
                sort: sort,
                _cache_bust: new Date().getTime()
            }
        });
    }


    window.api_searchByBarcode = function(barcode) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_get_products',
                nonce: loycartPOS.nonce,
                search: barcode,
                page: 1,
                per_page: 1, 
                _cache_bust: new Date().getTime()
            }
        });
    }
    


    window.api_refreshNonce = function() {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_refresh_nonce',
                _cache_bust: new Date().getTime()
            }
        });
    }


    window.api_holdSale = function(cartJSON, customer_id, cart_total, held_name) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_hold_sale',
                nonce: loycartPOS.nonce,
                cart: cartJSON,
                customer_id: customer_id,
                cart_total: cart_total,
                held_name: held_name.trim()
            }
        });
    }

    /**
     * Fetches all currently held carts from the server.
     * @returns {Promise} The jQuery AJAX promise.
     */
    window.api_getHeldCarts = function() {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_get_held_carts',
                nonce: loycartPOS.nonce
            }
        });
    }


    window.api_resumeHeldCart = function(heldCartId) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_resume_held_cart',
                nonce: loycartPOS.nonce,
                held_cart_id: heldCartId
            }
        });
    }


    window.api_deleteHeldCart = function(heldCartId) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_delete_held_cart',
                nonce: loycartPOS.nonce,
                held_cart_id: heldCartId
            }
        });
    }
    
    


    window.api_searchCustomers = function(query) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_search_customers',
                nonce: loycartPOS.nonce,
                query: query
            }
        });
    }


    window.api_getCustomerAddress = function(customerId) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_get_customer_address',
                nonce: loycartPOS.nonce,
                customer_id: customerId
            }
        });
    }


    window.api_createCustomer = function(customerData) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_create_customer',
                nonce: loycartPOS.nonce,
                ...customerData
            }
        });
    }


    window.api_getShippingOptions = function(cartJSON, customerId, guestAddress) {
        const ajaxData = {
            action: 'loycart_pos_get_shipping_options',
            nonce: loycartPOS.nonce,
            cart: cartJSON
        };

        if (customerId) {
            ajaxData.customer_id = customerId;
        } else if (guestAddress) {
            ajaxData.guest_address = guestAddress;
        }

        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: ajaxData
        });
    }

window.api_getCartTotals = function(cartJSON, customer_id, selectedShipping, original_order_id = null, coupon_code = '') {
    return $.ajax({
        url: loycartPOS.ajax_url,
        method: 'POST',
        data: {
            action: 'loycart_calculate_cart_totals',
            nonce: loycartPOS.nonce,
            cart: cartJSON,
            customer_id: customer_id,
            shipping_method_id: selectedShipping ? selectedShipping.id : null,
            shipping_cost: selectedShipping ? selectedShipping.cost : 0,
            original_order_id: original_order_id,
            coupon_code: coupon_code
        }
    });
}


    window.api_createCustomProduct = function(productData) {
        const ajaxData = {
            action: 'loycart_pos_create_custom_product',
            nonce: loycartPOS.nonce,
            ...productData
        };
        
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: ajaxData
        });
    }


window.api_submitSale = function(saleData) {
    const ajaxData = {
        action: 'loycart_complete_sale',
        nonce: loycartPOS.nonce,
        ...saleData,
        applied_coupon: window.appliedCoupon || '' 
    };

    return $.ajax({
        url: loycartPOS.ajax_url,
        method: 'POST',
        data: ajaxData
    });
}


    window.api_getRefundableOrderItems = function(orderId) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_get_refundable_order_items',
                nonce: loycartPOS.nonce,
                order_id: orderId
            }
        });
    }


    window.api_processRefund = function(orderId, cartJSON, reason) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_pos_process_refund',
                nonce: loycartPOS.nonce,
                original_order_id: orderId,
                cart: cartJSON,
                reason: reason,
                refund_shipping: window.selectedShipping && window.selectedShipping.id ? true : false,
                shipping_method_id: window.selectedShipping ? window.selectedShipping.id : null,
                shipping_cost: window.selectedShipping ? window.selectedShipping.cost : 0
            }
        });
    }
    

window.api_get_customer_orders = function(customerId, search_query = '', status_filter = 'all', date_filter = '', page = 1) {
    return $.ajax({
        url: loycartPOS.ajax_url,
        method: 'POST',
        data: {
            action: 'loycart_pos_get_customer_orders',
            nonce: loycartPOS.nonce,
            customer_id: customerId,
            search_query: search_query,
            status_filter: status_filter,
            date_filter: date_filter,
            page: page
        }
    });
}


 

window.api_openCashDrawer = function() {
    return $.ajax({
        url: loycartPOS.ajax_url,
        method: 'POST',
        data: {
            action: 'loycart_ajax_open_cash_drawer',
            nonce: loycartPOS.nonce
        }
    });
} 
    

    window.api_validate_cart = function(staleCart) {
        return $.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_ajax_validate_cart',
                nonce: loycartPOS.nonce,
                cart: JSON.stringify(staleCart)
            }
        });
    }
    
    
    window.api_getAvailableCoupons = function(customerId = '0') {
        return jQuery.ajax({
            url: loycartPOS.ajax_url,
            method: 'POST',
            data: {
                action: 'loycart_ajax_get_available_coupons',
                nonce: loycartPOS.nonce,
                customer_id: customerId
            }
        });
    };

      // Store Credit: Fetch per-customer balance and coupon code
      window.api_getStoreCredit = function(customerId) {
          return $.ajax({
              url: loycartPOS.ajax_url,
              method: 'POST',
              data: {
                  action: 'loycart_pos_get_store_credit',
                  nonce: loycartPOS.nonce,
                  customer_id: customerId
              }
          });
      };

      // Store Credit Reports: fetch summary HTML for POS modal
      window.api_getStoreCreditReports = function(fromDate, toDate) {
          return $.ajax({
              url: loycartPOS.ajax_url,
              method: 'POST',
              data: {
                  action: 'loycart_pos_get_credit_reports',
                  nonce: loycartPOS.nonce,
                  from: fromDate,
                  to: toDate
              }
          });
      };

      // POS Settings: get current values
      window.api_getPosSettings = function() {
          return $.ajax({
              url: loycartPOS.ajax_url,
              method: 'POST',
              data: {
                  action: 'loycart_pos_get_settings',
                  nonce: loycartPOS.nonce
              }
          });
      };

      // POS Settings: save values
      window.api_savePosSettings = function(settingsObj) {
          return $.ajax({
              url: loycartPOS.ajax_url,
              method: 'POST',
              data: {
                  action: 'loycart_pos_save_settings',
                  nonce: loycartPOS.nonce,
                  store_credit: settingsObj.store_credit || {},
                  receipt: settingsObj.receipt || {},
                  ui: settingsObj.ui || {},
                  visibility: settingsObj.visibility || {}
              }
          });
      };

})(jQuery);