<?php
/**
 * Rewards Table Template
 *
 * @package WooCommerce Points and Rewards
 * @version 1.6.0
 */

defined( 'ABSPATH' ) || exit();

$rewards = $reward_helper->ddwcpr_get_coupon_rewards( $args );
?>
<div class="ddwcpr-table-container <?php echo esc_attr( 'rewards' === $current_tab ? '' : 'ddwcpr-hide' ); ?>" data-section="rewards">
	<div class="ddwcpr-table-loader-overlay">
		<div class="ddwcpr-table-loader-spinner"></div>
	</div>
	<div class="ddwcpr-table-wrapper">
		<table class="my_account_orders shop_table_responsive ddwcpr-table">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Code', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Type', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Created On', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Expiry', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Status', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Action', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php
				if ( ! empty( $rewards ) ) {
					$reward_helper->ddwcpr_render_rewards_table_rows( $rewards );
				} else {
					?>
					<tr>
						<td colspan="6"><center><?php esc_html_e( 'No rewards yet.', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></center></td>
					</tr>
					<?php
				}
				?>
			</tbody>
		</table>
	</div>
	<?php
	if ( $per_page < $rewards_count ) {
		?>
		<div class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination ddwcpr-pagination">
			<input type="hidden" class="ddwcpr-current-page" value="1" />
			<input type="hidden" class="ddwcpr-total-count" value="<?php echo esc_attr( $rewards_count ); ?>" />
			<button class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous button ddwcpr-pagination-button" data-table="rewards" data-perform="previous" disabled><?php esc_html_e( 'Previous', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
			<button class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next button ddwcpr-pagination-button" data-table="rewards" data-perform="next"><?php esc_html_e( 'Next', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
		</div>
		<?php
	}
	?>
</div>
