<?php
/**
 * Redeem Points Shortcode Template
 *
 * @package Points and Rewards for WooCommerce
 * @version 1.6.0
 */

defined( 'ABSPATH' ) || exit();

$redeeming_rules = $rule_helper->ddwcpr_get_redeeming_rules( [
	'per_page'     => 100,
	'offset'       => 0,
	'status'       => 'active',
	'current_date' => current_time( 'Y-m-d' ),
	'orderby'      => 'priority',
	'order'        => 'ASC', // Lower priority number = higher priority
] );

?>
<div class="ddwcpr-redeeming-methods <?php echo esc_attr( 'redeem' === $current_tab ? '' : 'ddwcpr-hide' ); ?>" data-section="redeem">
	<h3><?php esc_html_e( 'Ways You Can Redeem Points', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></h3>
	<div class="ddwcpr-rule-cards-container">
		<?php
		$has_visible_rules = false;
		if ( ! empty( $redeeming_rules ) ) {
			foreach ( $redeeming_rules as $rule ) {
				if ( 'hide' === $rule['show'] ) {
					continue;
				}

				$has_visible_rules = true;
				$additional_data   = maybe_unserialize( $rule['additional_data'] );
				$icon_url          = ! empty( $rule['icon'] ) ? wp_get_attachment_url( $rule['icon'] ) : ddwcpr_get_rules_icon( $rule['type'] );


				$tooltip_rows = '';
				ob_start();
				// Minimum Cart Amount
				if ( ! empty( $additional_data['minimum_cart_amount'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Minimum Cart Amount', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td><?php echo wc_price( $additional_data['minimum_cart_amount'] ); ?></td>
					</tr>
					<?php
				}
				// Maximum Cart Amount
				if ( ! empty( $additional_data['maximum_cart_amount'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Maximum Cart Amount', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td><?php echo wc_price( $additional_data['maximum_cart_amount'] ); ?></td>
					</tr>
					<?php
				}
				// Minimum Points
				if ( ! empty( $additional_data['minimum_points'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Minimum Points Required', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td><?php echo esc_html( $additional_data['minimum_points'] ); ?></td>
					</tr>
					<?php
				}
				// Maximum Points
				if ( ! empty( $additional_data['maximum_points'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Maximum Points Allowed', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td><?php echo esc_html( $additional_data['maximum_points'] ); ?></td>
					</tr>
					<?php
				}
				// Applicable Products
				if ( ! empty( $additional_data['applied_products'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Applicable Products', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td>
							<?php
							$product_links = [];
							foreach ( $additional_data['applied_products'] as $product_id ) {
								$product = wc_get_product( $product_id );
								if ( $product ) {
									$product_links[] = '<a href="' . esc_url( get_permalink( $product_id ) ) . '" target="_blank">' . esc_html( $product->get_name() ) . '</a>';
								}
							}
							echo implode( ', ', $product_links );
							?>
						</td>
					</tr>
					<?php
				}
				// Applicable Categories
				if ( ! empty( $additional_data['applied_categories'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Applicable Categories', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td>
							<?php
							$cat_links = [];
							foreach ( $additional_data['applied_categories'] as $cat_id ) {
								$cat = get_term( $cat_id, 'product_cat' );
								if ( $cat && ! is_wp_error( $cat ) ) {
									$cat_links[] = '<a href="' . esc_url( get_category_link( $cat_id ) ) . '" target="_blank">' . esc_html( $cat->name ) . '</a>';
								}
							}
							echo implode( ', ', $cat_links );
							?>
						</td>
					</tr>
					<?php
				}
				// Max Points Per Order
				if ( ! empty( $additional_data['maximum_points_per_order'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Max Points Per Order', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td><?php echo esc_html( $additional_data['maximum_points_per_order'] ); ?></td>
					</tr>
					<?php
				}
				$tooltip_rows = ob_get_clean();

				?>
				<div class="ddwcpr-rule-card">
					<div>
						<?php
						if ( ! empty( $ddwcpr_configuration['rule_icons_wrapper_enabled'] ) ) {
							?>
							<span class="ddwcpr-rule-card-icon-wrapper">
								<img src="<?php echo esc_url( $icon_url ); ?>" alt="<?php echo esc_attr( $rule['name'] ); ?>" />
							</span>
							<?php
						} else {
							?>
							<img src="<?php echo esc_url( $icon_url ); ?>" alt="<?php echo esc_attr( $rule['name'] ); ?>" />
							<?php
						}
						if ( 'points_conversion' === $rule['type'] ) {
							?>
							<span class="ddwcpr-rule-points-value">
								<?php echo sprintf( esc_html__( '%d %s = %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), $additional_data['points_value'], ddwcpr_get_points_label( $additional_data['points_value'] ), wc_price( $additional_data['discount_value'] ) ); ?>
							</span>
							<?php
						} else {
							?>
							<span class="ddwcpr-rule-points-value">
								<?php echo esc_html( -$additional_data['points_value'] . ' ' . ddwcpr_get_points_label( $additional_data['points_value'] ) ); ?>
							</span>
							<?php
						}
						?>
					</div>
					<div>
						<h4><?php echo esc_html( $rule['name'] ); ?></h4>
						<?php
						if ( ! empty( $tooltip_rows ) ) {
							?>
							<span class="ddwcpr-tooltip-icon">
								&#9432;
								<span class="ddwcpr-tooltip-content">
									<table class="ddwcpr-tooltip-details-table">
										<thead>
											<tr>
												<th colspan="2"><?php esc_html_e( 'Special Conditions', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
											</tr>
										</thead>
										<tbody>
											<?php echo wp_kses_post( $tooltip_rows ); ?>
										</tbody>
									</table>
								</span>
							</span>
							<?php
						}
						?>
						<p><?php echo wp_kses_post( $rule['description'] ); ?></p>
						<?php
						if ( 'percentage_discount' === $rule['type'] ) {
							?>
							<span class="ddwcpr-points-value"><?php echo wp_kses_post( sprintf( esc_html__( '%s discount', 'loyaltyx-points-and-rewards-for-woocommerce' ), $additional_data['discount_value'] . '%' ) ); ?></span>
							<?php
						} elseif ( 'fixed_discount' === $rule['type'] ) {
							?>
							<span class="ddwcpr-points-value"><?php echo wp_kses_post( sprintf( esc_html__( '%s discount', 'loyaltyx-points-and-rewards-for-woocommerce' ), wc_price( $additional_data['discount_value'] ) ) ); ?></span>
							<?php
						}
						?>
					</div>
					<form method="post">
						<?php
						if ( 'points_conversion' === $rule['type'] ) {
							?>
							<div class="ddwcpr-points-conversion-inputs">
								<input type="number" class="form-control ddwcpr-points-conversion-input" name="ddwcpr_points_conversion_input" value="<?php echo esc_attr( $additional_data['points_value'] ) ?>" data-conversion-rate="<?php echo esc_attr( $additional_data['discount_value'] / $additional_data['points_value'] ); ?>" />
								=
								<div class="ddwcpr-points-conversion-amount">
									<span class="ddwcpr-points-conversion-amount-value"><?php echo esc_html( $additional_data['discount_value'] ); ?></span>
									<span class="ddwcpr-points-conversion-amount-currency"><?php echo get_woocommerce_currency_symbol() . '(' . get_woocommerce_currency() . ')'; ?></span>
								</div>
							</div>
							<?php
						}
						?>
						<?php wp_nonce_field( 'ddwcpr_nonce_action', 'ddwcpr_nonce' ); ?>
						<input type="hidden" name="ddwcpr_rule_id" value="<?php echo esc_attr( $rule['id'] ); ?>" />
						<button class="ddwcpr-redeem-reward-button button" type="submit" name="ddwcpr_redeem_button_submit" value="submit"><?php esc_html_e( 'Redeem Now', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
					</form>
				</div>
				<?php
			}
		}

		// If no visible rules, show global configuration rule as a points_conversion card
		if ( ! $has_visible_rules ) {
			$points_value                  = ! empty( $ddwcpr_configuration['points_redeeming_value'] ) ? absint( $ddwcpr_configuration['points_redeeming_value'] ) : 1;
			$amount_value                  = ! empty( $ddwcpr_configuration['points_redeeming_amount'] ) ? floatval( $ddwcpr_configuration['points_redeeming_amount'] ) : 1;
			$min_points                    = ! empty( $ddwcpr_configuration['points_redeeming_min_points'] ) ? absint( $ddwcpr_configuration['points_redeeming_min_points'] ) : 0;
			$max_points                    = ! empty( $ddwcpr_configuration['points_redeeming_max_points'] ) ? absint( $ddwcpr_configuration['points_redeeming_max_points'] ) : '';
			$excluded_products             = ! empty( $ddwcpr_configuration['points_redeeming_excluded_products'] ) ? $ddwcpr_configuration['points_redeeming_excluded_products'] : [];
			$excluded_categories           = ! empty( $ddwcpr_configuration['points_redeeming_excluded_categories'] ) ? $ddwcpr_configuration['points_redeeming_excluded_categories'] : [];
			$exclude_sale_products_enabled = ! empty( $ddwcpr_configuration['points_redeeming_exclude_sale_products_enabled'] ) ? $ddwcpr_configuration['points_redeeming_exclude_sale_products_enabled'] : '';

			$icon_url = ddwcpr_get_rules_icon( 'points_conversion' );
			?>
			<div class="ddwcpr-rule-card ddwcpr-global-redeem-rule">
				<div>
					<span class="ddwcpr-rule-card-icon-wrapper">
						<img src="<?php echo esc_url( $icon_url ); ?>" alt="<?php esc_attr_e( 'Points Conversion', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?>" />
					</span>
				</div>
				<div>
					<h4><?php esc_html_e( 'Points Conversion', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></h4>
					<span class="ddwcpr-tooltip-icon">
						&#9432;
						<span class="ddwcpr-tooltip-content">
							<table class="ddwcpr-tooltip-details-table">
								<thead>
									<tr>
										<th colspan="2"><?php esc_html_e( 'Conversion Details', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td><strong><?php esc_html_e( 'Conversion Rate', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
										<td><?php echo sprintf( esc_html__( '%d %s = %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_value, ddwcpr_get_points_label( $points_value ), wc_price( $amount_value ) ); ?></td>
									</tr>
									<tr>
										<td><strong><?php esc_html_e( 'Minimum Points to Redeem', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
										<td><?php echo esc_html( $min_points ); ?></td>
									</tr>
									<tr>
										<td><strong><?php esc_html_e( 'Maximum Redeemable Points', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
										<td><?php echo esc_html( $max_points ? $max_points : esc_html__( 'No Limit', 'loyaltyx-points-and-rewards-for-woocommerce' ) ); ?></td>
									</tr>
									<?php
									// Excluded Products
									if ( ! empty( $excluded_products ) ) {
										?>
										<tr>
											<td><strong><?php esc_html_e( 'Excluded Products', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
											<td>
												<?php
												$product_links = [];
												foreach ( $excluded_products as $product_id ) {
													$product = wc_get_product( $product_id );
													if ( $product ) {
														$product_links[] = '<a href="' . esc_url( get_permalink( $product_id ) ) . '" target="_blank">' . esc_html( $product->get_name() ) . '</a>';
													}
												}
												echo implode( ', ', $product_links );
												?>
											</td>
										</tr>
										<?php
									}
									// Excluded Categories
									if ( ! empty( $excluded_categories ) ) {
										?>
										<tr>
											<td><strong><?php esc_html_e( 'Excluded Categories', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
											<td>
												<?php
												$cat_links = [];
												foreach ( $excluded_categories as $cat_id ) {
													$cat = get_term( $cat_id, 'product_cat' );
													if ( $cat && ! is_wp_error( $cat ) ) {
														$cat_links[] = '<a href="' . esc_url( get_category_link( $cat_id ) ) . '" target="_blank">' . esc_html( $cat->name ) . '</a>';
													}
												}
												echo implode( ', ', $cat_links );
												?>
											</td>
										</tr>
										<?php
									}
									// Exclude Sale Products
									if ( ! empty( $exclude_sale_products_enabled ) ) {
										?>
										<tr>
											<td><strong><?php esc_html_e( 'Exclude Sale Products', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
											<td><?php esc_html_e( 'Yes', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></td>
										</tr>
										<?php
									}
									?>
								</tbody>
							</table>
						</span>
					</span>
					<p><?php esc_html_e( 'Redeem your points for a discount. Enter the number of points you want to redeem below.', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></p>
					<span class="ddwcpr-rule-points-value">
						<?php echo sprintf( esc_html__( '%d %s = %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_value, ddwcpr_get_points_label( $points_value ), wc_price( $amount_value ) ); ?>
					</span>
				</div>
				<form method="post">
					<div class="ddwcpr-points-conversion-inputs">
						<input type="number" class="form-control ddwcpr-points-conversion-input" name="ddwcpr_points_conversion_input" min="<?php echo esc_attr( $min_points ); ?>" max="<?php echo esc_attr( $max_points ); ?>" value="<?php echo esc_attr( $min_points ? $min_points : $points_value ); ?>" data-conversion-rate="<?php echo esc_attr( $amount_value / $points_value ); ?>" />
						=
						<div class="ddwcpr-points-conversion-amount">
							<span class="ddwcpr-points-conversion-amount-value"><?php echo esc_html( $min_points ? $min_points * $amount_value / $points_value : $amount_value ); ?></span>
							<span class="ddwcpr-points-conversion-amount-currency"><?php echo get_woocommerce_currency_symbol() . '(' . get_woocommerce_currency() . ')'; ?></span>
						</div>
					</div>
					<?php wp_nonce_field( 'ddwcpr_nonce_action', 'ddwcpr_nonce' ); ?>
					<input type="hidden" name="ddwcpr_global_points_conversion" value="1" />
					<button class="ddwcpr-redeem-reward-button button" type="submit" name="ddwcpr_global_points_conversion_submit" value="submit"><?php esc_html_e( 'Redeem Now', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
				</form>
			</div>
			<?php
		}
		?>
	</div>
</div>
