<?php
/**
 * Points and Rewards Template
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit();

use DDWCPointsAndRewards\Helper\Reward\DDWCPR_Reward_Helper;

global $ddwcpr_configuration, $wp;

$user    = wp_get_current_user();
$user_id = $user->ID;

$reward_helper = new DDWCPR_Reward_Helper( $ddwcpr_configuration );

$current_page = 1;
$per_page     = 10;
$offset       = 1 === $current_page ? 0 : ( $current_page - 1 ) * $per_page;

$args = [
	'user_id'  => $user_id,
	'per_page' => $per_page,
	'offset'   => $offset,
];

include 'details-info.php';
include 'navigation.php';
