<?php
/**
 * Navigation Template
 *
 * @package WooCommerce Points and Rewards
 * @version 1.6.0
 */

use DDWCPointsAndRewards\Helper\Log\DDWCPR_Log_Helper;
use DDWCPointsAndRewards\Helper\Rule\DDWCPR_Rule_Helper;

defined( 'ABSPATH' ) || exit();

$log_helper   = new DDWCPR_Log_Helper( $ddwcpr_configuration );
$rule_helper  = new DDWCPR_Rule_Helper( $ddwcpr_configuration );

$endpoints = [
	'logs' => esc_html__( 'Logs', 'loyaltyx-points-and-rewards-for-woocommerce' ),
];

$endpoints['earn']    = esc_html__( 'Earn', 'loyaltyx-points-and-rewards-for-woocommerce' );
$endpoints['redeem']  = esc_html__( 'Redeem', 'loyaltyx-points-and-rewards-for-woocommerce' );
$endpoints['rewards'] = esc_html__( 'Rewards', 'loyaltyx-points-and-rewards-for-woocommerce' );

if ( ! empty( $shortcode_args['current_tab'] ) && array_key_exists( $shortcode_args['current_tab'], $endpoints ) ) {
	$current_tab = $shortcode_args['current_tab'];
} else {
	$current_tab = 'logs';
}
?>
<div class="ddwcpr-navigation-container">
	<ul class="ddwcpr-dashboard-navigation">
		<?php
		foreach ( $endpoints as $key => $endpoint_title ) {
			?>
			<li class="ddwcpr-dashboard-navigation-item <?php echo esc_attr( $current_tab === $key ? 'ddwcpr-active' : '' ); ?>" data-show-section="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $endpoint_title ); ?></li>
			<?php
		}
		?>
	</ul>
	<?php
	include 'logs-table.php';
	include 'earn-points.php';
	include 'redeem-points.php';
	include 'rewards-table.php';
	?>
</div>
