<?php
/**
 * Logs Table Shortcode Template
 *
 * @package WooCommerce Points and Rewards
 * @version 1.6.0
 */

defined( 'ABSPATH' ) || exit();

$logs       = $log_helper->ddwcpr_get_logs( $args );
$logs_count = $log_helper->ddwcpr_get_logs_count( $args );

?>
<div class="ddwcpr-table-container <?php echo esc_attr( 'logs' === $current_tab ? '' : 'ddwcpr-hide' ); ?>" data-section="logs">
	<div class="ddwcpr-table-loader-overlay">
		<div class="ddwcpr-table-loader-spinner"></div>
	</div>
	<div class="ddwcpr-table-wrapper">
		<table class="my_account_orders shop_table_responsive ddwcpr-table">
			<thead>
				<tr>
					<th><?php esc_html_e( 'Event', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Points', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Description', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th><?php esc_html_e( 'Related ID', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
					<th class="ddwcpr-logs-table-date-column"><?php esc_html_e( 'Date', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php
				if ( ! empty( $logs ) ) {
					$log_helper->ddwcpr_render_logs_table_rows( $logs );
				} else {
					?>
					<tr>
						<td colspan="5"><center><?php esc_html_e( 'No logs yet.', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></center></td>
					</tr>
					<?php
				}
				
				?>
			</tbody>
		</table>
	</div>
	<?php
	if ( $per_page < $logs_count ) {
		?>
		<div class="woocommerce-pagination woocommerce-pagination--without-numbers woocommerce-Pagination ddwcpr-pagination">
			<input type="hidden" class="ddwcpr-current-page" value="1" />
			<input type="hidden" class="ddwcpr-total-count" value="<?php echo esc_attr( $logs_count ); ?>" />
			<button class="woocommerce-button woocommerce-button--previous woocommerce-Button woocommerce-Button--previous button ddwcpr-pagination-button" data-table="logs" data-perform="previous" disabled><?php esc_html_e( 'Previous', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
			<button class="woocommerce-button woocommerce-button--next woocommerce-Button woocommerce-Button--next button ddwcpr-pagination-button" data-table="logs" data-perform="next"><?php esc_html_e( 'Next', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
		</div>
		<?php
	}
	?>
</div>
