<?php
/**
 * Earn Points Shortcode Template
 *
 * @package Points and Rewards for WooCommerce
 * @version 1.6.0
 */

defined( 'ABSPATH' ) || exit();

$earning_rules = $rule_helper->ddwcpr_get_earning_rules( [
	'per_page'     => 100,
	'offset'       => 0,
	'status'       => 'active',
	'current_date' => current_time( 'Y-m-d' ),
	'orderby'      => 'priority',
	'order'        => 'ASC', // Lower priority number = higher priority
] );

$referral_rule = false;
$signup_rule   = false;

?>
<div class="ddwcpr-earning-methods <?php echo esc_attr( 'earn' === $current_tab ? '' : 'ddwcpr-hide' ); ?>" data-section="earn">
	<h3><?php esc_html_e( 'Ways You Can Earn Points', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></h3>
	<div class="ddwcpr-rule-cards-container">
		<?php
		if ( ! empty( $earning_rules ) ) {
			foreach ( $earning_rules as $rule ) {
				if ( 'hide' === $rule['show'] ) {
					continue;
				}

				if ( 'referral' === $rule['type'] ) {
					$referral_rule = $rule;
				}

				if ( 'signup' === $rule['type'] ) {
					$signup_rule = $rule;
				}

				$additional_data = maybe_unserialize( $rule['additional_data'] );

				$icon_url = ! empty( $rule['icon'] ) ? wp_get_attachment_url( $rule['icon'] ) : ddwcpr_get_rules_icon( $rule['type'] );

				$tooltip_rows = '';

				ob_start();

				if ( ! empty( $additional_data['minimum_order_value'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Minimum Order Value', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td><?php echo wc_price( $additional_data['minimum_order_value'] ); ?></td>
					</tr>
					<?php
				}
				if ( ! empty( $additional_data['maximum_points_per_order'] ) ) {
					?>
					<tr>
						<td><strong><?php esc_html_e( 'Max Points Per Order', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></strong></td>
						<td><?php echo esc_html( $additional_data['maximum_points_per_order'] ); ?></td>
					</tr>
					<?php
				}

				$tooltip_rows = ob_get_clean();

				?>
				<div class="ddwcpr-rule-card">
					<div>
						<?php
						if ( ! empty( $ddwcpr_configuration['rule_icons_wrapper_enabled'] ) ) {
							?>
							<span class="ddwcpr-rule-card-icon-wrapper">
								<img src="<?php echo esc_url( $icon_url ); ?>" alt="<?php echo esc_attr( $rule['name'] ); ?>" />
							</span>
							<?php
						} else {
							?>
							<img src="<?php echo esc_url( $icon_url ); ?>" alt="<?php echo esc_attr( $rule['name'] ); ?>" />
							<?php
						}
						?>
						<!-- Points Value Display -->
						<?php
						$points_display = '';
						if ( 'level_up_points' === $rule['type'] && ! empty( $additional_data['level_points'][ $next_level_id ] ) ) {
							$points_display = sprintf( esc_html__( '+%d %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), $additional_data['level_points'][ $next_level_id ], ddwcpr_get_points_label( $additional_data['level_points'][ $next_level_id ] ) );
						} elseif ( 'fixed_points_based_on_amount' === $additional_data['points_type'] ) {
							$points_display = sprintf( esc_html__( '+%d %s for every %s spent', 'loyaltyx-points-and-rewards-for-woocommerce' ), $additional_data['points_value'], ddwcpr_get_points_label( $additional_data['points_value'] ), wc_price( $additional_data['points_per_amount'] ) );
						} elseif ( 'fixed_points' === $additional_data['points_type'] ) {
							$points_display = sprintf( esc_html__( '+%d %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), $additional_data['points_value'], ddwcpr_get_points_label( $additional_data['points_value'] ) );
						} elseif ( 'percentage_points' === $additional_data['points_type'] ) {
							$points_display = sprintf( esc_html__( '+%s%% of order as %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), $additional_data['points_value'], ddwcpr_get_points_label( $additional_data['points_value'] ) );
						}
						?>
						<span class="ddwcpr-rule-points-value">
							<?php echo wp_kses_post( $points_display ); ?>
						</span>
					</div>
					<div>
						<h4><?php echo esc_html( $rule['name'] ); ?></h4>
						<?php
						if ( ! empty( $tooltip_rows ) ) {
							?>
							<span class="ddwcpr-tooltip-icon">
								&#9432;
								<span class="ddwcpr-tooltip-content">
									<table class="ddwcpr-tooltip-details-table">
										<thead>
											<tr>
												<th colspan="2"><?php esc_html_e( 'Special Conditions', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></th>
											</tr>
										</thead>
										<tbody>
											<?php echo wp_kses_post( $tooltip_rows ); ?>
										</tbody>
									</table>
								</span>
							</span>
							<?php
						}
						?>
						<p><?php echo esc_html( $rule['description'] ); ?></p>
							<?php
							if ( 'level_up_points' === $rule['type'] && ! empty( $additional_data['level_points'][ $next_level_id ] ) ) {
								?>
								<span class="ddwcpr-points-value"><?php echo esc_html( sprintf( esc_html__( 'On reaching %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), $next_level['name'] ) ); ?></span>
								<?php
							}
							?>
						</span>
					</div>
					<?php
					if ( 'daily_login' === $rule['type'] ) {
						if ( ! $log_helper->ddwcpr_check_daily_login_log_exists( $user_id, current_time( 'Y-m-d' ) ) ) {
							?>
							<form method="post">
								<?php wp_nonce_field( 'ddwcpr_nonce_action', 'ddwcpr_nonce' ); ?>
								<input type="hidden" name="ddwcpr_rule_id" value="<?php echo esc_attr( $rule['id'] ); ?>" />
								<button class="ddwcpr-claim-points-button button" type="submit" name="ddwcpr_claim_points_submit" value="submit"><?php esc_html_e( 'Claim Points', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
							</form>
							<?php
						} else {
							?>
							<div>
								<button class="button" disabled><?php esc_html_e( 'Claimed', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
							</div>
							<?php
						}
					} elseif ( 'purchase_amount' === $rule['type'] || 'product_purchase' === $rule['type'] || 'review_submission' === $rule['type'] || 'level_up_points' === $rule['type'] ) {
						?>
						<div>
							<a href="<?php echo esc_url( wc_get_page_permalink( 'shop' ) ); ?>" class="button" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Shop Now', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></a>
						</div>
						<?php
					} elseif ( 'referral' === $rule['type'] ) {
						?>
						<div>
							<button class="button ddwcpr-get-referral-link"><?php esc_html_e( 'Get Referral Link', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
						</div>
						<?php
					} elseif ( 'signup' === $rule['type'] ) {
						?>
						<div>
							<a href="<?php echo esc_url( get_permalink( get_option( 'woocommerce_myaccount_page_id' ) ) ); ?>" class="button" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Sign Up', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></a>
						</div>
						<?php
					} elseif ( 'birthday' === $rule['type'] ) {
						if ( empty( get_user_meta( $user_id, '_ddwcpr_birthday', true ) ) ) {
							?>
							<div>
								<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-account' ) ); ?>" class="button" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Set Birthday', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></a>
							</div>
							<?php
						} else {
							?>
							<div>
								<button class="button" disabled><?php esc_html_e( 'Birthday Set', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></button>
							</div>
							<?php
						}
					}
					?>
				</div>
				<?php
			}
		}
		?>
	</div>
	<?php
	if ( $referral_rule ) {
		$referral_url                  = add_query_arg( 'ddwcpr-ref', $user->user_login, site_url() );
		$referral_rule_additional_data = maybe_unserialize( $referral_rule['additional_data'] );

		if ( $signup_rule ) {
			$signup_rule_additional_data = maybe_unserialize( $signup_rule['additional_data'] );

			$referral_message = sprintf( esc_html__( "Share your referral link and earn %d %s when someone signs up using it. They'll also receive %d %s on registration as a welcome bonus!", 'loyaltyx-points-and-rewards-for-woocommerce' ), $referral_rule_additional_data['points_value'], ddwcpr_get_points_label( $referral_rule_additional_data['points_value'] ), $signup_rule_additional_data['points_value'], ddwcpr_get_points_label( $signup_rule_additional_data['points_value'] ) );
		} else {
			$referral_message = sprintf( esc_html__( "Share your referral link and earn %d %s when someone signs up using it.", 'loyaltyx-points-and-rewards-for-woocommerce' ), $referral_rule_additional_data['points_value'], ddwcpr_get_points_label( $referral_rule_additional_data['points_value'] ) );
		}
		?>
		<div class="ddwcpr-popup-overlay" id="popup">
			<div class="ddwcpr-popup-content">
				<button class="ddwcpr-popup-close">×</button>
				<div class="ddwcpr-referral-link-container">
					<h3><?php esc_html_e( 'Your Referral URL', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></h3>
					<p><?php echo esc_html( $referral_message ) ?></p>
					<?php ddwcpr_get_copy_text_field( esc_url( $referral_url ) ); ?>
				</div>
			</div>
		</div>
		<?php
	}
	?>
</div>
