<?php
/**
 * Earn Points Shortcode Template
 *
 * @package Points and Rewards for WooCommerce
 * @version 1.6.0
 */

use DevDiggers\Framework\Includes\DDFW_SVG;
use DDWCPointsAndRewards\Helper\Point\DDWCPR_Point_Helper;

defined( 'ABSPATH' ) || exit();

$point_helper = new DDWCPR_Point_Helper( $ddwcpr_configuration );

$image_path              = DDWCPR_PLUGIN_URL . 'assets/images/';
$earned_points           = $point_helper->ddwcpr_get_user_earned_points( $user_id );
$available_redeem_points = $point_helper->ddwcpr_get_user_available_points( $user_id );
$total_referrals         = $point_helper->ddwcpr_get_user_total_referrals( $user_id );
$redeemed_points         = $earned_points - $available_redeem_points;
$rewards_count           = $reward_helper->ddwcpr_get_rewards_count( $args );

$earned_points_icon    = ! empty( $ddwcpr_configuration['layout_icon_total_earned_points'] ) ? wp_get_attachment_url( $ddwcpr_configuration['layout_icon_total_earned_points'] ) : $image_path . 'total-earned-points.svg';
$available_points_icon = ! empty( $ddwcpr_configuration['layout_icon_available_points'] ) ? wp_get_attachment_url( $ddwcpr_configuration['layout_icon_available_points'] ) : $image_path . 'available-points.svg';
$redeemed_points_icon  = ! empty( $ddwcpr_configuration['layout_icon_redeemed_points'] ) ? wp_get_attachment_url( $ddwcpr_configuration['layout_icon_redeemed_points'] ) : $image_path . 'redeemed-points.svg';
$coupon_reward_icon    = ! empty( $ddwcpr_configuration['layout_icon_coupon_reward'] ) ? wp_get_attachment_url( $ddwcpr_configuration['layout_icon_coupon_reward'] ) : $image_path . 'coupon-reward.svg';
$referrals_icon        = ! empty( $ddwcpr_configuration['layout_icon_referrals'] ) ? wp_get_attachment_url( $ddwcpr_configuration['layout_icon_referrals'] ) : $image_path . 'referrals.svg';

$top_cards = [
	'total_earned_points' => [
		'title' => sprintf( esc_html__( 'Total Earned %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), ddwcpr_get_points_label( $earned_points ) ),
		'value' => $earned_points,
		'icon'  => $earned_points_icon,
	],
	'available_points'   => [
		'title' => sprintf( esc_html__( 'Available %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), ddwcpr_get_points_label( $available_redeem_points ) ),
		'value' => $available_redeem_points,
		'icon'  => $available_points_icon,
	],
	'redeemed_points'   => [
		'title' => sprintf( esc_html__( 'Redeemed %s', 'loyaltyx-points-and-rewards-for-woocommerce' ), ddwcpr_get_points_label( $redeemed_points ) ),
		'value' => $redeemed_points,
		'icon'  => $redeemed_points_icon,
	],
	'converted_coupons' => [
		'title' => esc_html__( 'Converted Coupons', 'loyaltyx-points-and-rewards-for-woocommerce' ),
		'value' => $rewards_count,
		'icon'  => $coupon_reward_icon,
	],
	'total_referrals'   => [
		'title' => esc_html__( 'Total Referrals', 'loyaltyx-points-and-rewards-for-woocommerce' ),
		'value' => $total_referrals,
		'icon'  => $referrals_icon,
	],
];

?>
<div class="ddwcpr-points-info-container">
	<?php
	foreach ( $top_cards as $key => $top_card ) {
		?>
		<div class="ddwcpr-points-info">
			<span class="ddwcpr-points-value-wrapper">
				<p><?php echo esc_html( $top_card['title'] ); ?></p>
				<span class="ddwcpr-points-value"><?php echo esc_html( $top_card['value'] ); ?></span>
			</span>
			<?php
			if ( ! empty( $ddwcpr_configuration['details_icons_enabled'] ) ) {
				if ( ! empty( $ddwcpr_configuration['details_icon_' . $key ] ) ) {
					$icon_url = wp_get_attachment_url( $ddwcpr_configuration['details_icon_' . $key ] );
					?>
					<img src="<?php echo esc_url( $icon_url ); ?>" alt="<?php echo esc_attr( $top_card['title'] ); ?>" width="<?php echo esc_attr( $ddwcpr_configuration['details_icon_size'] ); ?>" height="<?php echo esc_attr( $ddwcpr_configuration['details_icon_size'] ); ?>" />
					<?php
				} else {
					$svg_args = [
						'size'         => $ddwcpr_configuration['details_icon_size'],
						'stroke_width' => 1,
						'stroke_color' => $ddwcpr_configuration['details_icon_color'],
					];

					if ( ! empty( $ddwcpr_configuration['details_icons_wrapper_enabled'] ) ) {
						$svg_args['wrapper'] = [
							'element' => 'div',
							'class'   => 'ddwcpr-details-icon-wrapper',
						];
					}

					DDFW_SVG::get_svg_icon(
						$key,
						false,
						$svg_args
					);
				}
			}
			?>
		</div>
		<?php
	}
	?>
</div>
