<?php
/**
 * Points redeeming template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Points_Rules;

use DDWCPointsAndRewards\Templates\Admin;
use DevDiggers\Framework\Includes\DDFW_SVG;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Points_Redeeming_Template' ) ) {
	/**
	 * Points redeeming template class
	 */
	class DDWCPR_Points_Redeeming_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			settings_errors();
			if ( ! empty( $_GET['action'] ) && ( 'add' === sanitize_text_field( wp_unslash( $_GET['action'] ) ) || 'edit' === sanitize_text_field( wp_unslash( $_GET['action'] ) ) ) ) {
				new Points_Redeeming\DDWCPR_Manage_Points_Redeeming_Rule_Template( $ddwcpr_configuration );
			} else {
				if ( ! empty( $_GET['action'] ) && ( 'saved' === sanitize_text_field( wp_unslash( $_GET['action'] ) ) ) ) {
					ddfw_print_notification( esc_html__( 'Rule is saved successfully.', 'loyaltyx-points-and-rewards-for-woocommerce' ), 'success' );
				}

				$page        = ! empty( $_GET['page'] ) ? sanitize_text_field( wp_unslash( $_GET['page'] ) ) : '';
				$menu        = ! empty( $_GET['menu'] ) ? sanitize_text_field( wp_unslash( $_GET['menu'] ) ) : '';
				$current_tab = ! empty( $_GET['tab'] ) ? sanitize_title( wp_unslash( $_GET['tab'] ) ) : 'points-earning';
				$obj         = new Points_Redeeming\DDWCPR_Points_Redeeming_Rules_List_Template( $ddwcpr_configuration );
				?>
				<form method="get">
					<hr class="wp-header-end" />
					<h1 class="wp-heading-inline"><?php esc_html_e( 'Points Redeeming Rules', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></h1>
					<a href="<?php echo esc_url( admin_url( "admin.php?page={$page}&menu={$menu}&tab={$current_tab}&action=add" ) ); ?>" class="page-title-action button-primary button">
						<?php
						DDFW_SVG::get_svg_icon(
							'plus',
							false,
							[ 'size' => 15 ]
						);
						esc_html_e( 'Add New', 'loyaltyx-points-and-rewards-for-woocommerce' );
						?>
					</a>

					<input type="hidden" name="page" value="<?php echo isset( $_GET['page'] ) ? esc_attr( sanitize_text_field( wp_unslash( $_GET['page'] ) ) ) : ''; // WPCS: CSRF ok. // WPCS: input var ok. ?>" />
					<input type="hidden" name="menu" value="<?php echo isset( $_GET['menu'] ) ? esc_attr( sanitize_text_field( wp_unslash( $_GET['menu'] ) ) ) : ''; // WPCS: CSRF ok. // WPCS: input var ok. ?>" />
					<input type="hidden" name="paged" value="<?php echo isset( $_GET['paged'] ) ? esc_attr( sanitize_text_field( wp_unslash( $_GET['paged'] ) ) ) : ''; // WPCS: CSRF ok. // WPCS: input var ok. ?>" />
					<input type="hidden" name="tab" value="<?php echo isset( $_GET['tab'] ) ? esc_attr( sanitize_text_field( wp_unslash( $_GET['tab'] ) ) ) : ''; // WPCS: CSRF ok. // WPCS: input var ok. ?>" />
					<?php
					wp_nonce_field( 'ddwcpr_nonce_action', 'ddwcpr_nonce' );
					$obj->prepare_items();
					$obj->search_box( esc_html__( 'Search', 'loyaltyx-points-and-rewards-for-woocommerce' ), 'search-id' );
					$obj->display();
					?>
				</form>
				<?php
			}
		}
	}
}
