<?php
/**
 * Shortcodes Configuration template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Configuration;

use DevDiggers\Framework\Includes\DDFW_Layout;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Shortcodes_Configuration_Template' ) ) {
	/**
	 * Shortcodes Configuration template class
	 */
	class DDWCPR_Shortcodes_Configuration_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			$args = [
				[
					'header' => [
						'heading'     => esc_html__( 'Shortcodes Settings', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure some shortcode settings to use the plugin.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Points Dashboard', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Default: [ddwcpr_points_dashboard] — Displays the complete Points and Rewards layout, including user points summary, earning methods, redeeming options, and points log table.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-dashboard-shortcode',
							'value'       => $ddwcpr_configuration['points_dashboard_shortcode'],
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Available Points Value', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Default: [ddwcpr_available_points_value] — Displays the total value of the user’s currently available points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-available-points-value-shortcode',
							'value'       => $ddwcpr_configuration['available_points_value_shortcode'],
						],
					],
				],
			];

			$layout = new DDFW_Layout();
			$layout->get_form_section_layout( $args, 'ddwcpr-shortcodes-configuration-fields' );
		}
	}
}
