<?php
/**
 * Points Redeeming Configuration template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Configuration;

use DevDiggers\Framework\Includes\DDFW_Layout;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Points_Redeeming_Configuration_Template' ) ) {
	/**
	 * Points Redeeming Configuration template class
	 */
	class DDWCPR_Points_Redeeming_Configuration_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			$args = [
				[
					'header' => [
						'heading'     => esc_html__( 'Global Points Conversion Rate', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Customize how points are converted into discounts across your store. These settings define the basic structure of your redemption system.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'          => 'two_input_columns',
							'default_class' => false,
							'label'         => esc_html__( 'Points Conversion', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'columns'       => [
								[
									'type'    => 'number',
									'id'      => 'ddwcpr-points-redeeming-value',
									'value'   => $ddwcpr_configuration['points_redeeming_value'],
									'min'     => 0,
									'suffix'  => '&nbsp;<span id="ddwcpr-rule-points-value-points">' . esc_html__( 'Points', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '</span>&nbsp;=&nbsp;',
									'wrapper' => 'span',
								],
								[
									'type'    => 'number',
									'id'      => 'ddwcpr-points-redeeming-amount',
									'value'   => $ddwcpr_configuration['points_redeeming_amount'],
									'min'     => 0,
									'suffix'  => '&nbsp;' . get_woocommerce_currency_symbol() . '(' . get_woocommerce_currency() . ')' . '&nbsp;',
									'wrapper' => 'span',
								],
							],
							'description' => sprintf( esc_html__( 'You can override this by creating %sadvanced rules%s.', 'loyaltyx-points-and-rewards-for-woocommerce' ), '<a href="' . admin_url( 'admin.php?page=ddwcpr-dashboard&menu=points-rules&tab=points-redeeming' ) . '" target="_blank">', '</a>' ),
							'after_field_text' => '<p class="description"><i>' . esc_html__( 'Set the base rate of points when customers choose to redeem them at checkout.', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '</i></p>',
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Restrictions', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure minimum and maximum points that can be redeemed per reward.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'number',
							'label'             => esc_html__( 'Minimum Points to Redeem', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Set the minimum number of points a customer must have before they can redeem them.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-redeeming-min-points',
							'value'             => $ddwcpr_configuration['points_redeeming_min_points'],
							'min'               => 0,
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'number',
							'label'             => esc_html__( 'Maximum Redeemable Points', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Set the maximum number of points that can be redeemed. Leave empty for no limit.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-redeeming-max-points',
							'value'             => $ddwcpr_configuration['points_redeeming_max_points'],
							'min'               => 0,
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Exclude Products and Categories', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure the products and categories that should be excluded from redeeming points. Use this section to define exceptions to your points redeeming rules and ensure specific items or groups are not eligible for points redemption.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'products',
							'label'             => esc_html__( 'Exclude Specific Products', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Choose individual products where points cannot be redeemed.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => '_ddwcpr_points_redeeming_excluded_products',
							'name'              => '_ddwcpr_points_redeeming_excluded_products[]',
							'value'             => $ddwcpr_configuration['points_redeeming_excluded_products'],
							'custom_attributes' => [
								'multiple' => true,
								'disabled' => 'disabled',
							]
						],
						[
							'type'              => 'categories',
							'label'             => esc_html__( 'Exclude Specific Categories', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Choose entire product categories where points cannot be redeemed.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => '_ddwcpr_points_redeeming_excluded_categories',
							'name'              => '_ddwcpr_points_redeeming_excluded_categories[]',
							'value'             => $ddwcpr_configuration['points_redeeming_excluded_categories'],
							'custom_attributes' => [
								'multiple' => true,
								'disabled' => 'disabled',
							]
						],
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Exclude Sale Products', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Exclude On Sale Products from Redemption', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Prevent customers from redeeming points on already discounted products.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-redeeming-exclude-sale-products-enabled',
							'value'             => $ddwcpr_configuration['points_redeeming_exclude_sale_products_enabled'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
					],
				],
			];

			$layout = new DDFW_Layout();
			$layout->get_form_section_layout( $args, 'ddwcpr-points-redeeming-configuration-fields' );
		}
	}
}
