<?php
/**
 * Points Expiration Configuration template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Configuration;

use DevDiggers\Framework\Includes\DDFW_Layout;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Points_Expiration_Configuration_Template' ) ) {
	/**
	 * Points Expiration Configuration template class
	 */
	class DDWCPR_Points_Expiration_Configuration_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			$args = [
				[
					'header' => [
						'heading'     => esc_html__( 'Points Expiration', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure if you want to enable points expiration for users.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Enable Points Expiration', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Enable if you want to set an expiration time on the points rewarded to your users.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-expiration-enabled',
							'value'             => $ddwcpr_configuration['points_expiration_enabled'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'number',
							'label'             => esc_html__( 'Points will expire in', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Set a default expiration time on the rewarded points on your store.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-expiration-time',
							'value'             => $ddwcpr_configuration['points_expiration_time'],
							'after_field_text'  => esc_html__( 'In Days', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'min'      => 1,
								'disabled' => 'disabled',
							],
						],
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Send Email', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Send an Email Before Expiration of Points', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Enable if you want to send an email to notify your users for their rewarded points before its expiration.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-expiration-email-enabled',
							'value'             => $ddwcpr_configuration['points_expiration_email_enabled'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'number',
							'label'             => esc_html__( 'Send Email Notification Before Expiration', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Enter the number of days before the expiration date when the email notification should be sent to the user.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-expiration-email-time',
							'value'             => $ddwcpr_configuration['points_expiration_email_time'],
							'after_field_text'  => esc_html__( 'Before Number of Days', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'min'      => 1,
								'disabled' => 'disabled',
							],
						],
					],
				],
			];

			$layout = new DDFW_Layout();
			$layout->get_form_section_layout( $args );
		}
	}
}
