<?php
/**
 * Points Earning Configuration template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Configuration;

use DevDiggers\Framework\Includes\DDFW_Layout;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Points_Earning_Configuration_Template' ) ) {
	/**
	 * Points Earning Configuration template class
	 */
	class DDWCPR_Points_Earning_Configuration_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			$args = [
				[
					'header' => [
						'heading'     => esc_html__( 'Global Points Value', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Customize the basic earning structure applicable to all purchases in your store.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'          => 'two_input_columns',
							'default_class' => false,
							'label'         => esc_html__( 'Earn Points', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => sprintf( esc_html__( 'You can override this by creating %sadvanced rules%s.', 'loyaltyx-points-and-rewards-for-woocommerce' ), '<a href="' . admin_url( 'admin.php?page=ddwcpr-dashboard&menu=points-rules' ) . '" target="_blank">', '</a>' ),
							'after_field_text'   => '<p class="description"><i>' . esc_html__( 'Set a global default value for points earned per currency unit spent.', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '</i></p>',
							'columns'       => [
								[
									'prefix'      => esc_html__( 'For each', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '&nbsp;',
									'type'        => 'number',
									'id'          => 'ddwcpr-points-earning-per-amount',
									'value'       => $ddwcpr_configuration['points_earning_per_amount'],
									'min'         => 0,
									'suffix'      => '&nbsp;' . get_woocommerce_currency_symbol() . '(' . get_woocommerce_currency() . ')' . '&nbsp;',
									'wrapper'     => 'span',
								],
								[
									'type'        => 'number',
									'id'          => 'ddwcpr-points-earning-value',
									'value'       => $ddwcpr_configuration['points_earning_value'],
									'min'         => 0,
									'suffix'      => '&nbsp;<span id="ddwcpr-rule-points-value-points">' . esc_html__( 'Points', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '</span>',
									'wrapper'     => 'span',
								],
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Points Calculation', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure whether taxes, shipping fees, and coupon discounts are included or excluded in the calculation of points earned. You can also specify how points should be rounded.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Include Taxes', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Include Taxes in Points Calculation', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Enable this option to include taxes when calculating points earned from orders.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-earning-include-taxes-enabled',
							'value'             => $ddwcpr_configuration['points_earning_include_taxes_enabled'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Include Shipping', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Include Shipping in Points Calculation', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Enable this option to include shipping costs when calculating points earned.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-earning-include-shipping-enabled',
							'value'             => $ddwcpr_configuration['points_earning_include_shipping_enabled'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Exclude Coupon Discounts', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Exclude Coupon Discounts from Points Calculation', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Enable this option to exclude coupon discounts from the points calculation.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-earning-exclude-coupon-enabled',
							'value'             => $ddwcpr_configuration['points_earning_exclude_coupon_enabled'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'        => 'radio',
							'label'       => esc_html__( 'Points Rounding', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Specify how to round the points earned from purchases.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-earning-rounding',
							'value'       => $ddwcpr_configuration['points_earning_rounding'],
							'options'     => [
								'round_up'         => esc_html__( 'Round Up', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'round_down'       => esc_html__( 'Round Down', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'round_to_nearest' => esc_html__( 'Round to Nearest', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Exclude Products and Categories', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure the products and categories that should be excluded from earning points. Use this section to define exceptions to your points earning rules and ensure specific items or groups are not eligible for points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'products',
							'label'             => esc_html__( 'Exclude Specific Products', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Select the products that should not be eligible for earning points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => '_ddwcpr_points_earning_excluded_products',
							'name'              => '_ddwcpr_points_earning_excluded_products[]',
							'value'             => $ddwcpr_configuration['points_earning_excluded_products'],
							'custom_attributes' => [
								'multiple' => true,
								'disabled' => 'disabled',
							]
						],
						[
							'type'              => 'categories',
							'label'             => esc_html__( 'Exclude Specific Categories', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Select the product categories that should not be eligible for earning points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => '_ddwcpr_points_earning_excluded_categories',
							'name'              => '_ddwcpr_points_earning_excluded_categories[]',
							'value'             => $ddwcpr_configuration['points_earning_excluded_categories'],
							'custom_attributes' => [
								'multiple' => true,
								'disabled' => 'disabled',
							]
						],
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Exclude Sale Products', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Exclude Products on Sale', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Enable this option to exclude products that are currently on sale from earning points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-points-earning-exclude-sale-products-enabled',
							'value'             => $ddwcpr_configuration['points_earning_exclude_sale_products_enabled'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
					],
				],
			];

			$layout = new DDFW_Layout();
			$layout->get_form_section_layout( $args, 'ddwcpr-points-earning-configuration-fields' );
		}
	}
}
