<?php
/**
 * Layout Configuration template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Configuration;

use DevDiggers\Framework\Includes\DDFW_Layout;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Layout_Configuration_Template' ) ) {
	/**
	 * Layout Configuration template class
	 */
	class DDWCPR_Layout_Configuration_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			$args = [
				[
					'header' => [
						'heading'     => esc_html__( 'Icons', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'This section allows you to customize the icons displayed alongside points details on the layout. Icons visually enhance the user interface, making the points and rewards section more engaging and easier to understand.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Show Icons', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Icons for Points Details', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable this option to display icons next to points details such as total earned points, available points, etc.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-details-icons-enabled',
							'value'          => $ddwcpr_configuration['details_icons_enabled'],
						],
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Show Wrapper', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Wrapper for Details Icons', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable this option to display a wrapper around the icons next to points details such as total earned points, available points, etc.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-details-icons-wrapper-enabled',
							'value'          => $ddwcpr_configuration['details_icons_wrapper_enabled'],
						],
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Show Wrapper in Rule Icons', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Wrapper for Rule Icons', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable this option to display a wrapper around the icons next to points rules such as earning rules, redemption rules, etc.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-rule-icons-wrapper-enabled',
							'value'          => $ddwcpr_configuration['rule_icons_wrapper_enabled'],
						],
						[
							'type'           => 'number',
							'label'          => esc_html__( 'Icon Size', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Set the size for the icons displayed next to points details such as total earned points, available points, etc. (in pixels)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-details-icon-size',
							'value'          => $ddwcpr_configuration['details_icon_size'],
						],
						[
							'type'          => 'image',
							'label'         => esc_html__( 'Icon for Total Earned Points', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => esc_html__( 'Choose an icon (100x100px) to represent total earned points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-details-icon-total-earned-points',
							'value'         => $ddwcpr_configuration['details_icon_total_earned_points'],
						],
						[
							'type'          => 'image',
							'label'         => esc_html__( 'Icon for Available Points', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => esc_html__( 'Choose an icon (100x100px) that represents the points currently available for redemption.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-details-icon-available-points',
							'value'         => $ddwcpr_configuration['details_icon_available_points'],
						],
						[
							'type'          => 'image',
							'label'         => esc_html__( 'Icon for Redeemed Points', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => esc_html__( 'Choose an icon (100x100px) to visually represent points redeemed by the customer.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-details-icon-redeemed-points',
							'value'         => $ddwcpr_configuration['details_icon_redeemed_points'],
						],
						[
							'type'          => 'image',
							'label'         => esc_html__( 'Icon for Expired Points [PRO]', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => esc_html__( 'Choose an icon (100x100px) to represent points that have expired.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-details-icon-expired-points',
							'value'         => $ddwcpr_configuration['details_icon_expired_points'],
						],
						[
							'type'          => 'image',
							'label'         => esc_html__( 'Icon for Coupon Rewards', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => esc_html__( 'Choose an icon (100x100px) to represent coupon reward.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-details-icon-coupon-reward',
							'value'         => $ddwcpr_configuration['details_icon_coupon_reward'],
						],
						[
							'type'          => 'image',
							'label'         => esc_html__( 'Icon for Referrals', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => esc_html__( 'Choose an icon (100x100px) to represent referrals.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-details-icon-referrals',
							'value'         => $ddwcpr_configuration['details_icon_referrals'],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'This section allows you to customize the colors displayed alongside points details on the My Account page. Add visual appeal by customizing the text or background colors for cards displayed to customers.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Details Icon Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a color for the icons displayed next to points details such as total earned points, available points, etc.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-details-icon-color',
							'value'       => $ddwcpr_configuration['details_icon_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Details Icon Wrapper Background Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a background color for the icon wrappers displayed next to points details such as total earned points, available points, etc.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-details-icon-wrapper-background-color',
							'value'       => $ddwcpr_configuration['details_icon_wrapper_background_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Background Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a background color for the cards.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-details-card-background-color',
							'value'       => $ddwcpr_configuration['details_card_background_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Border Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a border color for the cards.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-details-card-border-color',
							'value'       => $ddwcpr_configuration['details_card_border_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Text Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a text color for the cards.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-details-card-text-color',
							'value'       => $ddwcpr_configuration['details_card_text_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Value Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a value color for the cards.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-details-card-value-color',
							'value'       => $ddwcpr_configuration['details_card_value_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Level Progress Bar Background Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a background color for the level progress bar.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-layout-level-progress-bar-background-color',
							'value'       => $ddwcpr_configuration['layout_level_progress_bar_background_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Level Progress Bar Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a color for the level progress bar.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-layout-level-progress-bar-color',
							'value'       => $ddwcpr_configuration['layout_level_progress_bar_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Table Header Text Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a text color for the table headings', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-layout-table-header-text-color',
							'value'       => $ddwcpr_configuration['layout_table_header_text_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Table Header Background Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a background color for the table heading.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-layout-table-header-background-color',
							'value'       => $ddwcpr_configuration['layout_table_header_background_color'],
						],
						[
							'type'        => 'colorpicker',
							'label'       => esc_html__( 'Rule Icons Wrapper Background Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a background color for the icon wrappers displayed next to points rules such as earning rules, redemption rules, etc.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-layout-rule-icons-wrapper-background-color',
							'value'       => $ddwcpr_configuration['layout_rule_icons_wrapper_background_color'],
						],
					],
				],
			];

			$layout = new DDFW_Layout();
			$layout->get_form_section_layout( $args, 'ddwcpr-layout-configuration-fields' );
		}
	}
}
