<?php
/**
 * General Configuration template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Configuration;

use DevDiggers\Framework\Includes\DDFW_Layout;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_General_Configuration_Template' ) ) {
	/**
	 * General Configuration template class
	 */
	class DDWCPR_General_Configuration_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			$args = [
				[
					'header' => [
						'heading'     => esc_html__( 'Global Settings', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure some global settings to use the plugin.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable WooCommerce Points and Rewards', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'This allows the module functionality to be used on the frontend.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-enabled',
							'value'          => $ddwcpr_configuration['enabled'],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Order Status Settings for Points Earning and Redeeming', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure how order statuses affect the earning and redeeming of points. You can define when points are awarded, or revoked based on specific WooCommerce order statuses.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'              => 'select',
							'label'             => esc_html__( 'Award Points on Order Status', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Select order statuses where points will be awarded to customers.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'options'           => wc_get_order_statuses(),
							'id'                => 'ddwcpr-award-order-status',
							'name'              => '_ddwcpr_award_order_status[]',
							'value'             => $ddwcpr_configuration['award_order_status'],
							'custom_attributes' => [
								'multiple' => true,
							],
						],
						[
							'type'              => 'select',
							'label'             => esc_html__( 'Revoke Points on Order Status', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Select order statuses where earned or redeemed points will be revoked.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'options'           => wc_get_order_statuses(),
							'id'                => 'ddwcpr-revoke-order-status',
							'name'              => '_ddwcpr_revoke_order_status[]',
							'value'             => $ddwcpr_configuration['revoke_order_status'],
							'custom_attributes' => [
								'multiple' => true,
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'My Account Menu', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure settings for the My Accounts menu.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Show Menu', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Enable Points and Rewards Menu on the My Account Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Disable this if you want to use the custom page with the shortcode to provide the points and rewards access to your customers.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-my-account-enabled',
							'value'             => $ddwcpr_configuration['my_account_enabled'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'text',
							'label'             => esc_html__( 'Endpoint', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Default: points-and-rewards', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-my-account-endpoint',
							'value'             => $ddwcpr_configuration['my_account_endpoint'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'text',
							'label'             => esc_html__( 'Endpoint Title', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'Default: Points and Rewards', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-my-account-endpoint-title',
							'value'             => $ddwcpr_configuration['my_account_endpoint_title'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'checkbox',
							'label'             => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label'    => esc_html__( 'Enable Sidebar Widgets', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'       => esc_html__( 'This allows the widgets to be shown on the sidebar on the points and rewards menu.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-enable-widgets-my-account-endpoint',
							'value'             => $ddwcpr_configuration['enable_widgets_my_account_endpoint'],
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
					],
				],
			];

			$layout = new DDFW_Layout();
			$layout->get_form_section_layout( $args, 'ddwcpr-general-configuration-fields' );
		}
	}
}
