<?php
/**
 * Emails Configuration template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Configuration;

use DevDiggers\Framework\Includes\DDFW_Layout;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Emails_Configuration_Template' ) ) {
	/**
	 * Emails Configuration template class
	 */
	class DDWCPR_Emails_Configuration_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			$args = [
				[
					'header' => [
						'heading'     => esc_html__( 'Points Earned Email', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'When customers earn points through purchases or other actions, they should be notified promptly. This email not only informs them of their new points but also encourages further engagement with the store.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-email-settings-points-earned-heading',
							'name'        => '_ddwcpr_email_settings[points_earned][heading]',
							'value'       => $ddwcpr_configuration['email_settings']['points_earned']['heading'],
							'description' => esc_html__( 'The main title that appears at the top of the email sent to customers when they earn points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-email-settings-points-earned-subject',
							'name'        => '_ddwcpr_email_settings[points_earned][subject]',
							'value'       => $ddwcpr_configuration['email_settings']['points_earned']['subject'],
							'description' => esc_html__( "The subject line of the email notification that appears in the customer's inbox when they earn points.", 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'   => esc_html__( 'Enter Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-email-settings-points-earned-message',
							'name'          => '_ddwcpr_email_settings[points_earned][message]',
							'value'         => $ddwcpr_configuration['email_settings']['points_earned']['message'],
							'textarea_rows' => 10,
							'description'   => sprintf( esc_html__( "The body of the email that informs the customer about the points they've earned, along with details like the order number and total points balance. \n\n Available Placeholders: %s, %s and %s.", 'loyaltyx-points-and-rewards-for-woocommerce' ), '<strong>[[points_amount]]</strong>', '<strong>[[points_reason]]</strong>', '<strong>[[user_available_points]]</strong>' ),
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Points Earned Reason Fields Descriptions', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => sprintf( esc_html__( 'Customize the %s text that will appear in email notifications when users earn points. This helps users understand why they received points and encourages ongoing engagement.', 'loyaltyx-points-and-rewards-for-woocommerce' ), '<strong>[[points_reason]]</strong>' ),
					],
					'fields' => [
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Order Completion', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Reason', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-reason-order-completion',
							'name'        => '_ddwcpr_points_reason[order_completion]',
							'value'       => $ddwcpr_configuration['points_reason']['order_completion'],
							'description' => esc_html__( 'Enter the reason text for points earned when a user successfully completes an order.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Referral', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Reason', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-reason-referral',
							'name'        => '_ddwcpr_points_reason[referral]',
							'value'       => $ddwcpr_configuration['points_reason']['referral'],
							'description' => esc_html__( 'Enter the reason text for points earned when a user successfully refers a friend to your store.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Birthday', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Reason', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-reason-birthday',
							'name'        => '_ddwcpr_points_reason[birthday]',
							'value'       => $ddwcpr_configuration['points_reason']['birthday'],
							'description' => esc_html__( 'Enter the reason text for points awarded to a user on their birthday.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Product Review', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Reason', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-reason-product-review',
							'name'        => '_ddwcpr_points_reason[review_submission]',
							'value'       => $ddwcpr_configuration['points_reason']['review_submission'],
							'description' => esc_html__( 'Enter the reason text for points earned when a user leaves a product review.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Sign Up', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Reason', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-reason-signup',
							'name'        => '_ddwcpr_points_reason[signup]',
							'value'       => $ddwcpr_configuration['points_reason']['signup'],
							'description' => esc_html__( "Enter the reason text for points awarded when a user creates a new account.", 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Level-Up', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Reason', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-reason-level-up',
							'name'        => '_ddwcpr_points_reason[level_up]',
							'value'       => $ddwcpr_configuration['points_reason']['level_up'],
							'description' => esc_html__( "Enter the reason text for points awarded when a user levels up.", 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Daily Login', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Reason', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-reason-daily-login',
							'name'        => '_ddwcpr_points_reason[daily_login]',
							'value'       => $ddwcpr_configuration['points_reason']['daily_login'],
							'description' => esc_html__( 'Enter the reason text for points earned when a user logs in daily.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Manual Adjustment by Admin Email', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'This section contains the email settings that will be used to notify users when their points balance is manually adjusted by an admin.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-email-settings-manual-adjustment-heading',
							'name'        => '_ddwcpr_email_settings[manual_adjustment][heading]',
							'value'       => $ddwcpr_configuration['email_settings']['manual_adjustment']['heading'],
							'description' => esc_html__( 'The title of the email that notifies users of manual adjustments made to their points balance by an admin.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-email-settings-manual-adjustment-subject',
							'name'        => '_ddwcpr_email_settings[manual_adjustment][subject]',
							'value'       => $ddwcpr_configuration['email_settings']['manual_adjustment']['subject'],
							'description' => esc_html__( 'The subject line of the email notifying users of manual adjustments to their points balance.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'   => esc_html__( 'Enter Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-email-settings-manual-adjustment-message',
							'name'          => '_ddwcpr_email_settings[manual_adjustment][message]',
							'value'         => $ddwcpr_configuration['email_settings']['manual_adjustment']['message'],
							'textarea_rows' => 10,
							'description'   => esc_html__( 'The body content of the email informing users about the manual adjustment of their points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Points Redeemed Email', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'This email confirms that the customer has successfully redeemed their points. It should provide all necessary details and encourage future redemptions.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-email-settings-points-redeemed-heading',
							'name'        => '_ddwcpr_email_settings[points_redeemed][heading]',
							'value'       => $ddwcpr_configuration['email_settings']['points_redeemed']['heading'],
							'description' => esc_html__( 'The main title that appears at the top of the email when customers redeem points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder' => esc_html__( 'Enter subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-email-settings-points-redeemed-subject',
							'name'        => '_ddwcpr_email_settings[points_redeemed][subject]',
							'value'       => $ddwcpr_configuration['email_settings']['points_redeemed']['subject'],
							'description' => esc_html__( 'The subject line for the points redemption confirmation email.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'   => esc_html__( 'Enter Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'            => 'ddwcpr-email-settings-points-redeemed-message',
							'name'          => '_ddwcpr_email_settings[points_redeemed][message]',
							'value'         => $ddwcpr_configuration['email_settings']['points_redeemed']['message'],
							'textarea_rows' => 10,
							'description'   => esc_html__( 'The body of the email that confirms the redemption of points and provides details such as the discount amount and remaining points balance.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Points Expiration Reminder Email', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'This email is crucial for creating urgency and encouraging customers to use their points before they expire.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'text',
							'label'             => esc_html__( 'Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-points-expiration-heading',
							'value'             => $ddwcpr_configuration['email_settings']['points_expiration']['heading'],
							'description'       => esc_html__( 'The main title that appears at the top of the email reminding customers that their points are about to expire.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'text',
							'label'             => esc_html__( 'Subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-points-expiration-subject',
							'value'             => $ddwcpr_configuration['email_settings']['points_expiration']['subject'],
							'description'       => esc_html__( 'The subject line for the points expiration reminder email.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'editor',
							'label'             => esc_html__( 'Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-points-expiration-message',
							'value'             => $ddwcpr_configuration['email_settings']['points_expiration']['message'],
							'textarea_rows'     => 10,
							'description'       => esc_html__( 'The body of the email that informs customers of their expiring points and encourages them to redeem them before the deadline. Use extra variables like [[user_expiring_points]] and [[user_points_expiration_date]] for this message.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Points Expired Email', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'This email confirms that the customer has successfully redeemed their points. It should provide all necessary details and encourage future redemptions.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'text',
							'label'             => esc_html__( 'Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-points-expired-heading',
							'value'             => $ddwcpr_configuration['email_settings']['points_expired']['heading'],
							'description'       => esc_html__( 'The title of the email sent to users to notify them that their points have expired.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'text',
							'label'             => esc_html__( 'Subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-points-expired-subject',
							'value'             => $ddwcpr_configuration['email_settings']['points_expired']['subject'],
							'description'       => esc_html__( 'The subject line of the email sent to users when their points have expired.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'editor',
							'label'             => esc_html__( 'Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-points-expired-message',
							'value'             => $ddwcpr_configuration['email_settings']['points_expired']['message'],
							'textarea_rows'     => 10,
							'description'       => esc_html__( 'The body content of the email that will inform users about their expired points and encourage future engagement with the rewards program.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Automatic Level Up Notifications', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'These notifications help keep users informed and excited about their progress, increasing motivation to continue earning points.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'class'  => 'ddfw-upgrade-to-pro-tag-wrapper',
					'fields' => [
						[
							'type'              => 'text',
							'label'             => esc_html__( 'Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter Heading', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-level-reached-heading',
							'value'             => $ddwcpr_configuration['email_settings']['level_reached']['heading'],
							'description'       => esc_html__( 'Set the email heading that will appear at the top of the level-up email.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'text',
							'label'             => esc_html__( 'Subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter subject', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-level-reached-subject',
							'value'             => $ddwcpr_configuration['email_settings']['level_reached']['subject'],
							'description'       => esc_html__( 'Customize the subject line of the level-up notification email.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
						[
							'type'              => 'editor',
							'label'             => esc_html__( 'Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'placeholder'       => esc_html__( 'Enter Email Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'                => 'ddwcpr-email-settings-level-reached-message',
							'value'             => $ddwcpr_configuration['email_settings']['level_reached']['message'],
							'textarea_rows'     => 10,
							'description'       => esc_html__( 'Write the email body text that congratulates the user on reaching a new level. You can include dynamic variables.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'custom_attributes' => [
								'disabled'    => 'disabled',
							],
						],
					],
				],
			];

			$layout = new DDFW_Layout();
			$layout->get_form_section_layout( $args, 'ddwcpr-emails-configuration-fields' );
		}
	}
}
