<?php
/**
 * Display Messages Configuration template class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Templates\Admin\Configuration;

use DevDiggers\Framework\Includes\DDFW_Layout;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Display_Messages_Configuration_Template' ) ) {
	/**
	 * Display Messages Configuration template class
	 */
	class DDWCPR_Display_Messages_Configuration_Template {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			$placeholders = sprintf( esc_html__( 'You can use placeholders for dynamic values: %1$s %2$s[[points_value]]:%3$s For number of points earned. %1$s %2$s[[points_label]]:%3$s For points label. %1$s %2$s[[user_available_points]]:%3$s For user available points. %1$s %2$s[[choose_rewards_link]]:%3$s For choose rewards link. %1$s %2$s', 'loyaltyx-points-and-rewards-for-woocommerce' ), '<br />', '<strong>', '</strong>' );

			$args = [
				[
					'header' => [
						'heading'     => esc_html__( 'Global Settings', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure some global settings to use the plugin.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Display Messages', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'This allows the display messages functionality to be used on the frontend.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-show_messages-to-guest-users',
							'value'          => $ddwcpr_configuration['show_messages_to_guest_users'],
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Point Singular Label', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Singular label replacing "Point".', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-singlular-label',
							'value'       => $ddwcpr_configuration['points_singlular_label'],
						],
						[
							'type'        => 'text',
							'label'       => esc_html__( 'Point Plural Label', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Plural label replacing "Point".', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-plural-label',
							'value'       => $ddwcpr_configuration['points_plural_label'],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Message Styling', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Customize the appearance of your points messages across various positions on your store. Use this section to set the background, text color, padding, border radius, and other visual aspects of the messages.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'colorpicker',
							'label'          => esc_html__( 'Text Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Set the text color for the points message.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr_points_message_styling[color]',
							'value'          => $ddwcpr_configuration['points_message_styling']['color'],
						],
						[
							'type'           => 'colorpicker',
							'label'          => esc_html__( 'Background Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Set the background color of the points message.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr_points_message_styling[background_color]',
							'value'          => $ddwcpr_configuration['points_message_styling']['background_color'],
						],
						[
							'type'           => 'colorpicker',
							'label'          => esc_html__( 'Border Color', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Set the border color of the points message.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr_points_message_styling[border_color]',
							'value'          => $ddwcpr_configuration['points_message_styling']['border_color'],
						],
						[
							'type'           => 'text',
							'label'          => esc_html__( 'Font Size', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Define the font size for the points message text (in pixels).', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr_points_message_styling[font_size]',
							'value'          => $ddwcpr_configuration['points_message_styling']['font_size'],
						],
						[
							'type'           => 'text',
							'label'          => esc_html__( 'Padding', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enter the inner spacing of the points message box (in pixels).', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr_points_message_styling[padding]',
							'value'          => $ddwcpr_configuration['points_message_styling']['padding'],
						],
						[
							'type'           => 'text',
							'label'          => esc_html__( 'Margin', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enter the outer spacing of the points message box (in pixels).', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr_points_message_styling[margin]',
							'value'          => $ddwcpr_configuration['points_message_styling']['margin'],
						],
						[
							'type'           => 'text',
							'label'          => esc_html__( 'Border Radius', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Add rounded corners to the message box (in pixels).', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr_points_message_styling[border_radius]',
							'value'          => $ddwcpr_configuration['points_message_styling']['border_radius'],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Message in My Accounts Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure the message that displays on the my accounts page, showing customers the points they can earn for signing up or completing account-related actions.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Points Message on My Accounts Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable to show the points-earning message on the my accounts page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-points-message[my_account_page][enabled]',
							'value'          => $ddwcpr_configuration['points_message']['my_account_page']['enabled'],
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Points Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => sprintf( esc_html__( "Enter the message text to display to customers. %s", 'loyaltyx-points-and-rewards-for-woocommerce' ), $placeholders ),
							'id'            => 'ddwcpr-points-message-my_account_page-message',
							'name'          => '_ddwcpr_points_message[my_account_page][message]',
							'value'         => $ddwcpr_configuration['points_message']['my_account_page']['message'],
							'textarea_rows' => 4,
						],
						[
							'type'        => 'select',
							'label'       => esc_html__( 'Display Position', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a position where the message will appear on the my accounts page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-message[my_account_page][position]',
							'value'       => $ddwcpr_configuration['points_message']['my_account_page']['position'],
							'options'     => [
								'woocommerce_before_customer_login_form'   => esc_html__( 'Before Login/Registration Form (Default)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_customer_login_form'    => esc_html__( 'After Login/Registration Form', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_login_form_start'              => esc_html__( 'Login Form Start', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_login_form_end'                => esc_html__( 'Login Form End', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_register_form_start'          => esc_html__( 'Registration Form Start', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_register_form_end'             => esc_html__( 'Registration Form End', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Message in Product Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure the message that displays on product pages, showing customers the points they can earn for purchasing a specific product.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Points Message on Product Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable to show the points-earning message on product pages.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-points-message[product_page][enabled]',
							'value'          => $ddwcpr_configuration['points_message']['product_page']['enabled'],
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Points Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => sprintf( esc_html__( "Enter the message text to display to customers. %s", 'loyaltyx-points-and-rewards-for-woocommerce' ), $placeholders ),
							'id'            => 'ddwcpr-points-message-product_page-message',
							'name'          => '_ddwcpr_points_message[product_page][message]',
							'value'         => $ddwcpr_configuration['points_message']['product_page']['message'],
							'textarea_rows' => 4,
						],
						[
							'type'        => 'select',
							'label'       => esc_html__( 'Display Position', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a position where the message will appear on the product page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-message[product_page][position]',
							'value'       => $ddwcpr_configuration['points_message']['product_page']['position'],
							'options'     => [
								'25' => esc_html__( 'Before Add to Cart Button (Default)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'35' => esc_html__( 'After Add To Cart Button', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'10' => esc_html__( 'After Product Image', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'8'  => esc_html__( 'After Product Title', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'3'  => esc_html__( 'Before Product Title', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'5'  => esc_html__( 'Before Tab Information', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Message in Shop Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure the message that displays on the shop/category pages, showing customers the points they can earn for products displayed in the shop grid.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Points Message on Shop Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable to show the points earning message below each product listing on the shop/category page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-points-message[shop_page][enabled]',
							'value'          => $ddwcpr_configuration['points_message']['shop_page']['enabled'],
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Points Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => sprintf( esc_html__( "Enter the message text to display to customers. %s", 'loyaltyx-points-and-rewards-for-woocommerce' ), $placeholders ),
							'id'            => 'ddwcpr-points-message-shop-page',
							'name'          => '_ddwcpr_points_message[shop_page][message]',
							'value'         => $ddwcpr_configuration['points_message']['shop_page']['message'],
							'textarea_rows' => 4,
						],
						[
							'type'        => 'select',
							'label'       => esc_html__( 'Display Position', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a position where the message will appear on the product page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-message[shop_page][position]',
							'value'       => $ddwcpr_configuration['points_message']['shop_page']['position'],
							'options'     => [
								'woocommerce_after_shop_loop_item_title'  => esc_html__( 'Before Add to Cart Button (Default)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_shop_loop_item'        => esc_html__( 'After Add to Cart Button', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_shop_loop_item_title'        => esc_html__( 'After the Product Title and Before the Price', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_before_shop_loop_item_title' => esc_html__( 'Before the Product Title', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_before_shop_loop_item'       => esc_html__( 'Before the Product Wrapper Starts', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Message in Cart Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( 'Configure the message displayed on the cart page, summarizing the points customers can earn for their current cart contents.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Points Message on Cart Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable to show the points earning message in the cart summary.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-points-message[cart_page][points_earning][enabled]',
							'value'          => $ddwcpr_configuration['points_message']['cart_page']['points_earning']['enabled'],
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Points Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => sprintf( esc_html__( "Enter the message text to display to customers. %s", 'loyaltyx-points-and-rewards-for-woocommerce' ), $placeholders ),
							'id'            => 'ddwcpr-points-message-cart-page',
							'name'          => '_ddwcpr_points_message[cart_page][points_earning][message]',
							'value'         => $ddwcpr_configuration['points_message']['cart_page']['points_earning']['message'],
							'textarea_rows' => 4,
						],
						[
							'type'        => 'select',
							'label'       => esc_html__( 'Display Position', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a position where the message will appear on the product page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-message[cart_page][points_earning][position]',
							'value'       => $ddwcpr_configuration['points_message']['cart_page']['points_earning']['position'],
							'options'     => [
								'woocommerce_before_cart_table' => esc_html__( 'Before the Cart Table (Default)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_before_cart' => esc_html__( 'Before the Cart Wrapper Starts', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_cart_table' => esc_html__( 'After the Cart Table', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_cart' => esc_html__( 'After the Entire Cart Section', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
						],
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable Redeem Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Points Redeem Message on Cart Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Show the points redeeming message in the cart summary.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-points-message[cart_page][points_redeeming][enabled]',
							'value'          => $ddwcpr_configuration['points_message']['cart_page']['points_redeeming']['enabled'],
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Points Redeem Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => sprintf( esc_html__( "Message for points customers can redeem. %s", 'loyaltyx-points-and-rewards-for-woocommerce' ), $placeholders ),
							'id'            => 'ddwcpr-points-message-cart-page-redeem',
							'name'          => '_ddwcpr_points_message[cart_page][points_redeeming][message]',
							'value'         => $ddwcpr_configuration['points_message']['cart_page']['points_redeeming']['message'],
							'textarea_rows' => 4,
						],
						[
							'type'        => 'select',
							'label'       => esc_html__( 'Display Position', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a position where the messages will appear on the cart page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-message[cart_page][points_redeeming][position]',
							'value'       => $ddwcpr_configuration['points_message']['cart_page']['points_redeeming']['position'],
							'options'     => [
								'woocommerce_before_cart_table' => esc_html__( 'Before the Cart Table (Default)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_before_cart' => esc_html__( 'Before the Cart Wrapper Starts', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_cart_table' => esc_html__( 'After the Cart Table', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_cart' => esc_html__( 'After the Entire Cart Section', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Message in Checkout Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( "Configure the message displayed on the checkout page, reminding customers about points they'll earn for completing their order.", 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Points Message on Checkout Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable to show the points earning message before placing an order.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-points-message[checkout_page][points_earning][enabled]',
							'value'          => $ddwcpr_configuration['points_message']['checkout_page']['points_earning']['enabled'],
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Points Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => sprintf( esc_html__( "Enter the message text to display to customers. %s", 'loyaltyx-points-and-rewards-for-woocommerce' ), $placeholders ),
							'id'            => 'ddwcpr-points-message-checkout-page',
							'name'          => '_ddwcpr_points_message[checkout_page][points_earning][message]',
							'value'         => $ddwcpr_configuration['points_message']['checkout_page']['points_earning']['message'],
							'textarea_rows' => 4,
						],
						[
							'type'        => 'select',
							'label'       => esc_html__( 'Display Position', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a position where the message will appear on the product page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-message[checkout_page][points_earning][position]',
							'value'       => $ddwcpr_configuration['points_message']['checkout_page']['points_earning']['position'],
							'options'     => [
								'woocommerce_before_checkout_form'          => esc_html__( 'Displays Content Before The Checkout Form Begins. (Default)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_checkout_form'           => esc_html__( 'Displays Content After The Checkout Form Ends.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_checkout_before_order_review'  => esc_html__( 'Displays Content Before The "Order Review Table" (The List Of Products).', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_checkout_after_order_review'   => esc_html__( 'Displays Content After The "Order Review Table."', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_before_checkout_billing_form'  => esc_html__( 'Displays Content Before The Billing Details Form.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_checkout_billing_form'   => esc_html__( 'Displays Content After The Billing Details Form.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_before_checkout_shipping_form' => esc_html__( 'Displays Content Before The Shipping Details Form.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_checkout_shipping_form'  => esc_html__( 'Displays Content After The Shipping Details Form.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_review_order_before_payment'   => esc_html__( 'Displays Content Before The Payment Section.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_review_order_after_payment'    => esc_html__( 'Displays Content After The Payment Section.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
						],
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable Redeem Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Points Redeem Message on Checkout Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Show the points redeeming message before placing an order.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-points-message[checkout_page][points_redeeming][enabled]',
							'value'          => $ddwcpr_configuration['points_message']['checkout_page']['points_redeeming']['enabled'],
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Points Redeem Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => sprintf( esc_html__( "Message for points customers can redeem. %s", 'loyaltyx-points-and-rewards-for-woocommerce' ), $placeholders ),
							'id'            => 'ddwcpr-points-message-checkout-page-redeem',
							'name'          => '_ddwcpr_points_message[checkout_page][points_redeeming][message]',
							'value'         => $ddwcpr_configuration['points_message']['checkout_page']['points_redeeming']['message'],
							'textarea_rows' => 4,
						],
						[
							'type'        => 'select',
							'label'       => esc_html__( 'Display Position', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose a position where the messages will appear on the checkout page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-message[checkout_page][points_redeeming][position]',
							'value'       => $ddwcpr_configuration['points_message']['checkout_page']['points_redeeming']['position'],
							'options'     => [
								'woocommerce_before_checkout_form'          => esc_html__( 'Before The Checkout Form (Default)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_checkout_form'           => esc_html__( 'After The Checkout Form', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_checkout_before_order_review'  => esc_html__( 'Before The "Order Review Table"', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_checkout_after_order_review'   => esc_html__( 'After The "Order Review Table"', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_before_checkout_billing_form'  => esc_html__( 'Before The Billing Details Form', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_checkout_billing_form'   => esc_html__( 'After The Billing Details Form', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_before_checkout_shipping_form' => esc_html__( 'Before The Shipping Details Form', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_after_checkout_shipping_form'  => esc_html__( 'After The Shipping Details Form', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_review_order_before_payment'   => esc_html__( 'Before The Payment Section', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_review_order_after_payment'    => esc_html__( 'After The Payment Section', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
						],
					],
				],
				[
					'header' => [
						'heading'     => esc_html__( 'Message in Order View & Received Page', 'loyaltyx-points-and-rewards-for-woocommerce' ),
						'description' => esc_html__( "Configure the message displayed on the order view and received pages after a successful order, informing customers about the points they've earned. This message helps reinforce engagement and encourages repeat purchases.", 'loyaltyx-points-and-rewards-for-woocommerce' ),
					],
					'fields' => [
						[
							'type'           => 'checkbox',
							'label'          => esc_html__( 'Enable/Disable', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'checkbox_label' => esc_html__( 'Enable Points Message on Order View & Received Pages', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'    => esc_html__( 'Enable to show the points earning message on the order view and received (thank you) page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'             => 'ddwcpr-points-message[view_order_page][enabled]',
							'value'          => $ddwcpr_configuration['points_message']['view_order_page']['enabled'],
						],
						[
							'type'          => 'editor',
							'label'         => esc_html__( 'Points Message', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description'   => sprintf( esc_html__( "Enter the message text to display to customers. %s", 'loyaltyx-points-and-rewards-for-woocommerce' ), $placeholders ),
							'id'            => 'ddwcpr-points-message-view-order-page',
							'name'          => '_ddwcpr_points_message[view_order_page][message]',
							'value'         => $ddwcpr_configuration['points_message']['view_order_page']['message'],
							'textarea_rows' => 4,
						],
						[
							'type'        => 'select',
							'label'       => esc_html__( 'Display Position', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'description' => esc_html__( 'Choose where the message will appear on the order received page.', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							'id'          => 'ddwcpr-points-message[view_order_page][position]',
							'value'       => $ddwcpr_configuration['points_message']['view_order_page']['position'],
							'options'     => [
								'woocommerce_order_details_before_order_table'     => esc_html__( 'Before Order Details Table (Default)', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_order_details_after_order_table'      => esc_html__( 'After Order Details Table', 'loyaltyx-points-and-rewards-for-woocommerce' ),
								'woocommerce_order_details_after_customer_details' => esc_html__( 'After Customer Details', 'loyaltyx-points-and-rewards-for-woocommerce' ),
							],
						],
					],
				],
			];

			$layout = new DDFW_Layout();
			$layout->get_form_section_layout( $args, 'ddwcpr-display-messages-configuration-fields' );
		}
	}
}
