<?php
/**
 * Create Schema on Activation
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Install' ) ) {
	/**
	 * Activation class
	 */
	class DDWCPR_Install {
		/**
		 * On plugin activation function
		 *
		 * @return void
		 */
		public static function ddwcpr_on_plugin_activation() {
			if ( ! get_option( '_ddwcpr_installed_at' ) ) {
				update_option( '_ddwcpr_installed_at', time() );
			}

			require_once ABSPATH . 'wp-admin/includes/upgrade.php';

			global $wpdb;

			$wpdb->ddwcpr_points_log      = $wpdb->prefix . 'ddwcpr_points_log';
			$wpdb->ddwcpr_earning_rules   = $wpdb->prefix . 'ddwcpr_earning_rules';
			$wpdb->ddwcpr_redeeming_rules = $wpdb->prefix . 'ddwcpr_redeeming_rules';
			$charset_collate              = $wpdb->get_charset_collate();

			// Points log table.
			dbDelta( "CREATE TABLE {$wpdb->ddwcpr_points_log} (
				`id` bigint(20) NOT NULL AUTO_INCREMENT,
				`user_id` bigint(20) NOT NULL,
				`points` bigint(20) DEFAULT 0,
				`description` varchar(250),
				`date` datetime NOT NULL,
				`event` varchar(50) NOT NULL,
				`related_id` bigint(20) DEFAULT NULL,
				PRIMARY KEY (id)
			) $charset_collate;" );

			// Earning rules log table.
			dbDelta( "CREATE TABLE {$wpdb->ddwcpr_earning_rules} (
				`id` bigint(20) NOT NULL AUTO_INCREMENT,
				`name` varchar(100) NOT NULL,
				`description` longtext NULL,
				`priority` int(10) NOT NULL,
				`type` varchar(50) NOT NULL,
				`applicable_to` varchar(50) NOT NULL,
				`additional_data` longtext NULL,
				`start_date` datetime NULL,
				`end_date` datetime NULL,
				`icon` bigint(20) NULL,
				`show` varchar(50) NOT NULL,
				`status` varchar(50) NOT NULL,
				PRIMARY KEY (id)
			) $charset_collate;" );

			// Points redeeming rules table.
			dbDelta( "CREATE TABLE {$wpdb->ddwcpr_redeeming_rules} (
				`id` bigint(20) NOT NULL AUTO_INCREMENT,
				`name` varchar(100) NOT NULL,
				`description` longtext NULL,
				`priority` int(10) NOT NULL,
				`type` varchar(50) NOT NULL,
				`applicable_to` varchar(50) NOT NULL,
				`additional_data` longtext NULL,
				`start_date` datetime NULL,
				`end_date` datetime NULL,
				`icon` bigint(20) NULL,
				`sharing` varchar(50) NOT NULL,
				`show` varchar(50) NOT NULL,
				`status` varchar(50) NOT NULL,
				PRIMARY KEY (id)
			) $charset_collate;" );
		}
	}
}
