<?php
/**
 * This file handles all front end action hooks.
 * 
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Includes\Front;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Front_Hooks' ) ) {
	/**
	 * Front end hooks class
	 */
	class DDWCPR_Front_Hooks extends DDWCPR_Front_Functions {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			parent::__construct( $ddwcpr_configuration );

			add_action( 'wp_enqueue_scripts', [ $this, 'ddwcpr_front_scripts' ] );

			if ( ! empty( $ddwcpr_configuration['show_messages_to_guest_users'] ) ) {
				if ( ! empty( $ddwcpr_configuration['points_message']['product_page']['enabled'] ) ) {
					if ( '5' === $ddwcpr_configuration['points_message']['product_page']['position'] ) {
						add_action( 'woocommerce_after_single_product_summary', [ $this, 'ddwcpr_display_earning_points_message' ], $ddwcpr_configuration['points_message']['product_page']['position' ] );
					} elseif ( '10' === $ddwcpr_configuration['points_message']['product_page']['position'] ) {
						add_action( 'woocommerce_product_thumbnails', [ $this, 'ddwcpr_display_earning_points_message' ], $ddwcpr_configuration['points_message' ]['product_page']['position'] );
					} else {
						add_action( 'woocommerce_single_product_summary', [ $this, 'ddwcpr_display_earning_points_message' ], $ddwcpr_configuration['points_message']['product_page']['position'] );
					}
				}

				if ( ! empty( $ddwcpr_configuration['points_message']['shop_page']['enabled'] ) ) {
					add_action( $ddwcpr_configuration['points_message']['shop_page']['position'], [ $this, 'ddwcpr_display_earning_points_message_product_loop' ] );
				}

				if ( ! empty( $ddwcpr_configuration['points_message']['cart_page']['points_earning']['enabled'] ) ) {
					add_action( $ddwcpr_configuration['points_message']['cart_page']['points_earning']['position'], [ $this, 'ddwcpr_display_earning_points_message_on_cart_or_checkout' ] );
				}

				if ( ! empty( $ddwcpr_configuration['points_message']['checkout_page']['points_earning']['enabled'] ) ) {
					add_action( $ddwcpr_configuration['points_message']['checkout_page']['points_earning']['position'], [ $this, 'ddwcpr_display_earning_points_message_on_cart_or_checkout' ] );
				}

				if ( ! empty( $ddwcpr_configuration['points_message']['cart_page']['points_redeeming']['enabled'] ) ) {
					add_action( $ddwcpr_configuration['points_message']['cart_page']['points_redeeming']['position'], [ $this, 'ddwcpr_display_redeeming_points_message_on_cart_or_checkout' ] );
				}

				if ( ! empty( $ddwcpr_configuration['points_message']['checkout_page']['points_redeeming']['enabled'] ) ) {
					add_action( $ddwcpr_configuration['points_message']['checkout_page']['points_redeeming']['position'], [ $this, 'ddwcpr_display_redeeming_points_message_on_cart_or_checkout' ] );
				}

				if ( ! empty( $ddwcpr_configuration['points_message']['view_order_page']['enabled'] ) ) {
					add_action( $ddwcpr_configuration['points_message']['view_order_page']['position'], [ $this, 'ddwcpr_display_earning_points_message_on_view_order_page' ] );
				}
			}

			add_filter( 'query_vars', [ $this, 'ddwcpr_add_query_vars' ] );

			if ( ! empty( $ddwcpr_configuration['my_account_enabled'] ) ) {
				add_filter( 'woocommerce_account_menu_items', [ $this, 'ddwcpr_add_woocommerce_menu' ] );

				add_action( 'woocommerce_account_' . $ddwcpr_configuration['my_account_endpoint'] . '_endpoint', [ $this, 'ddwcpr_add_my_account_endpoint_content' ] );

				add_filter( 'the_title', [ $this, 'ddwcpr_change_endpoint_title' ] );

				add_filter( 'sidebars_widgets', [ $this, 'ddwcpr_remove_sidebar_from_custom_menu_page' ] );
			}

			add_action( 'wp_loaded', [ $this, 'ddwcpr_handle_wp_loaded' ] );

			add_shortcode( $this->ddwcpr_validate_shortcode( $ddwcpr_configuration['points_dashboard_shortcode'] ), [ $this, 'ddwcpr_get_points_dashboard_shortcode_content' ] );

			add_shortcode( $this->ddwcpr_validate_shortcode( $ddwcpr_configuration['available_points_value_shortcode'] ), [ $this, 'ddwcpr_get_available_points_value_shortcode_content' ] );
		}

		/**
		 * Validate shortcode function
		 *
		 * @param string $shortcode
		 * @return string
		 */
		public function ddwcpr_validate_shortcode( $shortcode ) {
			$shortcode = str_replace( '[', '', $shortcode );
			$shortcode = str_replace( ']', '', $shortcode );
			$shortcode = str_replace( ' ', '', $shortcode );

			return $shortcode;
		}
	}
}
