<?php
/**
 * This file handles all front end ajax action hooks.
 *
 * @version 1.0.0
 * @package WooCommerce Points and Rewards
 */

namespace DDWCPointsAndRewards\Includes\Front;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Front_Ajax_Hooks' ) ) {
	/**
	 * Front end ajax hooks class
	 */
	class DDWCPR_Front_Ajax_Hooks extends DDWCPR_Front_Ajax_Functions {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			parent::__construct( $ddwcpr_configuration );

			add_action( 'wp_ajax_ddwcpr_get_table_rows', [ $this, 'ddwcpr_get_table_rows' ] );
			add_action( 'wp_ajax_nopriv_ddwcpr_get_table_rows', [ $this, 'ddwcpr_get_table_rows' ] );
			add_action( 'wp_ajax_ddwcpr_get_variation_points_message', [ $this, 'ddwcpr_get_variation_points_message' ] );
			add_action( 'wp_ajax_nopriv_ddwcpr_get_variation_points_message', [ $this, 'ddwcpr_get_variation_points_message' ] );
		}
	}
}
