<?php
/**
 * File handler
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Includes;

use DDWCPointsAndRewards\API\DDWCPR_API_Register_Routes;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_File_Handler' ) ) {
	/**
	 * File handler class
	 */
	class DDWCPR_File_Handler {
		/**
		 * Configuration Variable
		 *
		 * @var array
		 */
		protected $ddwcpr_configuration;

		/**
		 * Constructor
		 */
		public function __construct() {
			require_once DDWCPR_PLUGIN_FILE . 'includes/global-functions.php';

			$this->ddwcpr_configuration = $this->ddwcpr_set_globals();

			add_rewrite_endpoint( $this->ddwcpr_configuration['my_account_endpoint'], EP_ROOT | EP_PAGES );

			new Common\DDWCPR_Common_Hooks( $this->ddwcpr_configuration );
			new Front\DDWCPR_Front_Ajax_Hooks( $this->ddwcpr_configuration );

			if ( is_admin() ) {
				new DDWCPR_Admin_Dashboard( $this->ddwcpr_configuration );
				new Admin\DDWCPR_Admin_Hooks( $this->ddwcpr_configuration );
				new Admin\DDWCPR_Admin_Ajax_Hooks( $this->ddwcpr_configuration );
			} elseif ( ! empty( $this->ddwcpr_configuration['enabled'] ) ) {
				new Front\DDWCPR_Front_Hooks( $this->ddwcpr_configuration );
			}
		}

		/**
		 * Set globals function
		 *
		 * @return void
		 */
		public function ddwcpr_set_globals() {
			global $wpdb, $ddwcpr_configuration;

			$wpdb->ddwcpr_points_log      = $wpdb->prefix . 'ddwcpr_points_log';
			$wpdb->ddwcpr_earning_rules   = $wpdb->prefix . 'ddwcpr_earning_rules';
			$wpdb->ddwcpr_redeeming_rules = $wpdb->prefix . 'ddwcpr_redeeming_rules';

			$award_order_status  = get_option( '_ddwcpr_award_order_status' );
			$revoke_order_status = get_option( '_ddwcpr_revoke_order_status' );
			$my_account_endpoint       = get_option( '_ddwcpr_my_account_endpoint' );
			$my_account_endpoint_title = get_option( '_ddwcpr_my_account_endpoint_title' );

			$points_singlular_label = get_option( '_ddwcpr_points_singlular_label' );
			$points_plural_label    = get_option( '_ddwcpr_points_plural_label' );

			$points_earning_excluded_products   = get_option( '_ddwcpr_points_earning_excluded_products' );
			$points_earning_excluded_categories = get_option( '_ddwcpr_points_earning_excluded_categories' );

			$points_redeeming_excluded_products   = get_option( '_ddwcpr_points_redeeming_excluded_products' );
			$points_redeeming_excluded_categories = get_option( '_ddwcpr_points_redeeming_excluded_categories' );

			$margin_left = '5px';

			$points_earning_icon = '<svg style="margin-right: ' . $margin_left . ';" xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.123 2.123 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.123 2.123 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.122 2.122 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.122 2.122 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.122 2.122 0 0 0 1.597-1.16z"></path></svg>';

			$points_redeeming_icon = '<svg style="margin-right: ' . $margin_left . ';" xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"><path d="m15.477 12.89 1.515 8.526a.5.5 0 0 1-.81.47l-3.58-2.687a1 1 0 0 0-1.197 0l-3.586 2.686a.5.5 0 0 1-.81-.469l1.514-8.526"></path><circle cx="12" cy="8" r="6"></circle></svg>';

			$points_message_styling = [
				'background_color' => '#EEF3FF',
				'color'            => '#0256ff',
				'border_color'     => '#0256ff',
				'font_size'        => '15px',
				'padding'          => '12px 22px',
				'margin'           => '0px 0px 10px 0px',
				'border_radius'    => '6px',
			];

			$points_message = [
				'my_account_page' => [
					'enabled'  => 'yes',
					/* translators: %1$s: points earning icon, %2$s: opening strong tag, %3$s: closing strong tag */
					'message'  => sprintf( esc_html__( '%1$s Welcome to our loyalty program! Earn %2$s{points_value}%3$s {points_label} for creating your account and unlock exclusive rewards.', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_earning_icon, '<strong>', '</strong>' ),
					'position' => 'woocommerce_before_customer_login_form',
				],
				'product_page'  => [
					'enabled'  => 'yes',
					/* translators: %1$s: points earning icon, %2$s: opening strong tag, %3$s: closing strong tag */
					'message'  => sprintf( esc_html__( '%1$s Earn %2$s{points_value}%3$s {points_label} with this purchase!', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_earning_icon, '<strong>', '</strong>' ),
					'position' => '25',
				],
				'shop_page'     => [
					'enabled'  => 'yes',
					/* translators: %1$s: points earning icon, %2$s: opening strong tag, %3$s: closing strong tag */
					'message'  => sprintf( esc_html__( '%1$s Earn %2$s{points_value}%3$s {points_label}', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_earning_icon, '<strong>', '</strong>' ),
					'position' => 'woocommerce_after_shop_loop_item_title',
				],
				'cart_page'     => [
					'points_earning' => [
						'enabled'  => 'yes',
						/* translators: %1$s: points earning icon, %2$s: opening strong tag, %3$s: closing strong tag */
						'message'  => sprintf( esc_html__( '%1$s You\'ll earn %2$s{points_value}%3$s {points_label} for this order!', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_earning_icon, '<strong>', '</strong>' ),
						'position' => 'woocommerce_before_cart',
					],
					'points_redeeming' => [
						'enabled'  => 'yes',
						/* translators: %1$s: points redeeming icon, %2$s: opening span tag, %3$s: opening strong tag, %4$s: closing strong tag, %5$s: closing span tag */
						'message'  => sprintf( esc_html__( '%1$s %2$sGood news! Your %3$s{user_available_points}%4$s {points_label} can be redeemed for instant savings — {choose_rewards_link}.%5$s', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_redeeming_icon, '<span>', '<strong>', '</strong>', '</span>' ),
						'position' => 'woocommerce_before_cart',
					],
				],
				'checkout_page' => [
					'points_earning' => [
						'enabled'  => 'yes',
						/* translators: %1$s: points earning icon, %2$s: opening strong tag, %3$s: closing strong tag */
						'message'  => sprintf( esc_html__( '%1$s Complete your order now to earn %2$s{points_value}%3$s {points_label}!', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_earning_icon, '<strong>', '</strong>' ),
						'position' => 'woocommerce_before_checkout_form',
					],
					'points_redeeming' => [
						'enabled'  => 'yes',
						/* translators: %1$s: points redeeming icon, %2$s: opening strong tag, %3$s: closing strong tag */
						'message'  => sprintf( esc_html__( '%1$s You still have %2$s{user_available_points}%3$s {points_label} available! Redeem them now for instant savings before placing your order — {choose_rewards_link}.', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_redeeming_icon, '<strong>', '</strong>' ),
						'position' => 'woocommerce_before_checkout_form',
					],
				],
				'view_order_page' => [
					'enabled'  => 'yes',
					/* translators: %1$s: points earning icon, %2$s: opening strong tag, %3$s: closing strong tag */
					'message'  => sprintf( esc_html__( '%1$s Congratulations! You\'ve earned %2$s{points_value}%3$s {points_label} for your purchase.', 'loyaltyx-points-and-rewards-for-woocommerce' ), $points_earning_icon, '<strong>', '</strong>' ),
					'position' => 'woocommerce_order_details_before_order_table',
				],
			];

			$points_reason_defaults = [
				'order_completion'  => esc_html__( 'placing an order on our store', 'loyaltyx-points-and-rewards-for-woocommerce' ),
				'referral'          => esc_html__( 'referring a friend to our store', 'loyaltyx-points-and-rewards-for-woocommerce' ),
				'birthday'          => esc_html__( 'celebrating your birthday with us', 'loyaltyx-points-and-rewards-for-woocommerce' ),
				'review_submission' => esc_html__( 'leaving a valuable review on our product', 'loyaltyx-points-and-rewards-for-woocommerce' ),
				'signup'            => esc_html__( 'creating a new account', 'loyaltyx-points-and-rewards-for-woocommerce' ),
				'level_up'          => esc_html__( 'reaching a new level', 'loyaltyx-points-and-rewards-for-woocommerce' ),
				'daily_login'       => esc_html__( 'logging in daily to engage with our store', 'loyaltyx-points-and-rewards-for-woocommerce' ),
			];

			$email_settings = [
				'points_earned' => [
					'heading' => 'Congratulations! You\'ve Earned Points!',
					'subject' => 'You\'ve Earned {points_amount} Points!',
					'message' => '<p>Hi {user_display_name},</p>
								<p>Great news! You\'ve just earned {points_amount} {points_label} for {points_reason}. Your new points balance is {user_available_points} points.</p>
								<p>Keep up the great work and continue earning points to unlock exciting rewards!</p>
								<p>Thank you for being a valued customer.</p>
								<p>Best regards</p>',
				],
				'manual_adjustment' => [
					'heading' => 'Points Adjustment Notification',
					'subject' => 'Your Points Balance Has Been Updated',
					'message' => '<p>Hi {user_display_name},</p>
								<p>We wanted to inform you that your points balance has been adjusted by {points_amount} {points_label} due to {manual_adjustment_description}. Please review your updated balance below:</p>
								<p>Current points balance: {user_available_points}</p>
								<p>Thank you for understanding.</p>
								<p>Best regards</p>',
				],
				'points_redeemed' => [
					'heading' => 'Your Points Redemption Was Successful!',
					'subject' => 'You\'ve Redeemed {points_amount} {points_label} for a Coupon!',
					'message' => '<p>Hi {user_display_name},</p>
								<p>Congratulations! You\'ve successfully redeemed {points_amount} {points_label} for a coupon. Your coupon code is: {coupon_code}.</p>
								<p>You can use this coupon on your next purchase to enjoy great savings!</p>
								<p>Coupon details:</p>
								<p>{coupon_details}</p>
								<p>Thank you for being a valued customer!</p>
								<p>Best regards</p>',
				],
				'points_expiration' => [
					'heading' => 'Don\'t Let Your Points Expire!',
					'subject' => 'Your Points Will Expire On {user_points_expiration_date} - Redeem Them Now!',
					'message' => '<p>Hi {user_display_name},</p>
								<p>We wanted to remind you that your points balance of {user_expiring_points} points will expire on {user_points_expiration_date}. Make sure to use your points before this date to enjoy great rewards!</p>
								<p>Thank you for being a valued customer.</p>
								<p>Best regards</p>',
				],
				'points_expired' => [
					'heading' => 'Expired Points Alert',
					'subject' => 'Your Points Have Expired - Earn More Today!',
					'message' => '<p>Hi {user_display_name},</p>
								<p>We wanted to inform you that your {expired_points} points expired on {user_points_expiration_date}. Unfortunately, these points can no longer be used.</p>
								<p>We hope you continue to engage with our rewards program to earn more points in the future!</p>
								<p>Thank you for being a part of our community, and we look forward to seeing you again.</p>
								<p>Best regards</p>',
				],
				'level_reached' => [
					'heading' => 'You\'ve Reached a New Level!',
					'subject' => 'Congratulations, You\'ve Reached to {level_name}!',
					'message' => '<p>Hi {user_display_name},</p>
								<p>You\'ve earned enough points to reach the {level_name} level.</p>
								<p>Keep earning points to reach the next level and unlock more rewards!</p>
								<p>Thank you for being a part of our community, and we look forward to seeing you again.</p>
								<p>Best regards</p>',
				],
			];

			$points_dashboard_shortcode       = get_option( '_ddwcpr_points_dashboard_shortcode' );
			$available_points_value_shortcode = get_option( '_ddwcpr_available_points_value_shortcode' );

			$ddwcpr_configuration = [
				'enabled'                                        => get_option( '_ddwcpr_enabled' ),
				'award_order_status'                             => ! empty( $award_order_status ) ? $award_order_status : [ 'wc-processing', 'wc-completed' ],
				'revoke_order_status'                            => ! empty( $revoke_order_status ) ? $revoke_order_status : [ 'wc-refunded', 'wc-cancelled' ],
				'my_account_enabled'                             => get_option( '_ddwcpr_my_account_enabled', 'yes' ),
				'my_account_endpoint'                            => ! empty( $my_account_endpoint ) ? $my_account_endpoint : 'points-and-rewards',
				'my_account_endpoint_title'                      => ! empty( $my_account_endpoint_title ) ? $my_account_endpoint_title : esc_html__( 'Points and Rewards', 'loyaltyx-points-and-rewards-for-woocommerce' ),
				'enable_widgets_my_account_endpoint'             => get_option( '_ddwcpr_enable_widgets_my_account_endpoint' ),
				'points_earning_per_amount'                      => get_option( '_ddwcpr_points_earning_per_amount', 10 ),
				'points_earning_value'                           => get_option( '_ddwcpr_points_earning_value', 1 ),
				'points_earning_include_taxes_enabled'           => get_option( '_ddwcpr_points_earning_include_taxes_enabled' ),
				'points_earning_include_shipping_enabled'        => get_option( '_ddwcpr_points_earning_include_shipping_enabled' ),
				'points_earning_exclude_coupon_enabled'          => get_option( '_ddwcpr_points_earning_exclude_coupon_enabled', 'yes' ),
				'points_earning_rounding'                        => get_option( '_ddwcpr_points_earning_rounding', 'round_to_nearest' ),
				'points_earning_excluded_products'               => ! empty( $points_earning_excluded_products ) ? $points_earning_excluded_products : [],
				'points_earning_excluded_categories'             => ! empty( $points_earning_excluded_categories ) ? $points_earning_excluded_categories : [],
				'points_earning_exclude_sale_products_enabled'   => get_option( '_ddwcpr_points_earning_exclude_sale_products_enabled' ),
				'points_redeeming_amount'                        => get_option( '_ddwcpr_points_redeeming_amount', 1 ),
				'points_redeeming_value'                         => get_option( '_ddwcpr_points_redeeming_value', 10 ),
				'points_redeeming_min_points'                    => get_option( '_ddwcpr_points_redeeming_min_points', 100 ),
				'points_redeeming_max_points'                    => get_option( '_ddwcpr_points_redeeming_max_points', 1000 ),
				'points_redeeming_excluded_products'             => ! empty( $points_redeeming_excluded_products ) ? $points_redeeming_excluded_products : [],
				'points_redeeming_excluded_categories'           => ! empty( $points_redeeming_excluded_categories ) ? $points_redeeming_excluded_categories : [],
				'points_redeeming_exclude_sale_products_enabled' => get_option( '_ddwcpr_points_redeeming_exclude_sale_products_enabled' ),
				'points_expiration_enabled'                      => get_option( '_ddwcpr_points_expiration_enabled' ),
				'points_expiration_time'                         => get_option( '_ddwcpr_points_expiration_time', 30 ),
				'points_expiration_email_enabled'                => get_option( '_ddwcpr_points_expiration_email_enabled' ),
				'points_expiration_email_time'                   => get_option( '_ddwcpr_points_expiration_email_time', 7 ),
				'details_icons_enabled'                          => get_option( '_ddwcpr_details_icons_enabled', 'yes' ),
				'details_icons_wrapper_enabled'                  => get_option( '_ddwcpr_details_icons_wrapper_enabled', 'yes' ),
				'rule_icons_wrapper_enabled'                     => get_option( '_ddwcpr_rule_icons_wrapper_enabled', 'yes' ),
				'details_icon_size'                              => get_option( '_ddwcpr_details_icon_size', 40 ),
				'details_icon_total_earned_points'               => get_option( '_ddwcpr_details_icon_total_earned_points' ),
				'details_icon_available_points'                  => get_option( '_ddwcpr_details_icon_available_points' ),
				'details_icon_redeemed_points'                   => get_option( '_ddwcpr_details_icon_redeemed_points' ),
				'details_icon_expired_points'                    => get_option( '_ddwcpr_details_icon_expired_points' ),
				'details_icon_coupon_reward'                     => get_option( '_ddwcpr_details_icon_coupon_reward' ),
				'details_icon_referrals'                         => get_option( '_ddwcpr_details_icon_referrals' ),
				'details_icon_color'                             => get_option( '_ddwcpr_details_icon_color', '#0256ff' ),
				'details_icon_wrapper_background_color'          => get_option( '_ddwcpr_details_icon_wrapper_background_color', '#eef3ff' ),
				'details_card_background_color'                  => get_option( '_ddwcpr_details_card_background_color', '#ffffff' ),
				'details_card_border_color'                      => get_option( '_ddwcpr_details_card_border_color', '#dce6ff' ),
				'details_card_text_color'                        => get_option( '_ddwcpr_details_card_text_color', '#000' ),
				'details_card_value_color'                       => get_option( '_ddwcpr_details_card_value_color', '#0256ff' ),
				'layout_level_progress_bar_background_color'     => get_option( '_ddwcpr_layout_level_progress_bar_background_color', '#eef3ff' ),
				'layout_level_progress_bar_color'                => get_option( '_ddwcpr_layout_level_progress_bar_color', '#0256ff' ),
				'layout_table_header_text_color'                 => get_option( '_ddwcpr_layout_table_header_text_color', '#000000' ),
				'layout_table_header_background_color'           => get_option( '_ddwcpr_layout_table_header_background_color', '#f5f7f9' ),
				'layout_rule_icons_wrapper_background_color'     => get_option( '_ddwcpr_layout_rule_icons_wrapper_background_color', '#f5f7f9' ),
				'points_reason'                                  => get_option( '_ddwcpr_points_reason', $points_reason_defaults ),
				'email_settings'                                 => get_option( '_ddwcpr_email_settings', $email_settings ),
				'points_dashboard_shortcode'                     => ! empty( $points_dashboard_shortcode ) ? $points_dashboard_shortcode : '[ddwcpr_points_dashboard]',
				'available_points_value_shortcode'               => ! empty( $available_points_value_shortcode ) ? $available_points_value_shortcode : '[ddwcpr_available_points_value]',
				'show_messages_to_guest_users'                   => get_option( '_ddwcpr_show_messages_to_guest_users', 'yes' ),
				'points_singlular_label'                         => ! empty( $points_singlular_label ) ? $points_singlular_label : 'Point',
				'points_plural_label'                            => ! empty( $points_plural_label ) ? $points_plural_label : 'Points',
				'points_message_styling'                         => get_option( '_ddwcpr_points_message_styling', $points_message_styling ),
				'points_message'                                 => get_option( '_ddwcpr_points_message', $points_message ),
			];

			return $ddwcpr_configuration;
		}
	}
}
