<?php
/**
 * Common hooks class
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Includes\Common;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Common_Hooks' ) ) {
	/**
	 * Common hooks class
	 */
	class DDWCPR_Common_Hooks extends DDWCPR_Common_Functions {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			parent::__construct( $ddwcpr_configuration );

			add_filter( 'ddfw_modify_svg_icons', [ $this, 'ddwcpr_add_svg_icons' ], 10, 2 );

			add_filter( 'woocommerce_email_classes', [ $this, 'ddwcpr_add_new_email_notification' ] );

			add_filter( 'woocommerce_email_actions', [ $this, 'ddwcpr_add_notification_actions' ] );

			add_filter( 'woocommerce_order_status_changed', [ $this, 'ddwcpr_handle_order_status_changed' ], 10, 3 );

			// Replace coupon label in cart, checkout, and order review
			add_filter( 'woocommerce_cart_totals_coupon_label', [ $this, 'ddwcpr_replace_coupon_label_in_cart_checkout_order_review' ], 10, 2 );

			// Flag orders that use rewards coupons during checkout creation
			add_action( 'woocommerce_checkout_create_order', [ $this, 'ddwcpr_flag_order_if_rewards_generated_coupon' ], 20, 2 );
		}
	}
}
