<?php
/**
 * This file handles all admin end action hooks.
 *
 * @version 1.0.0
 * @package WooCommerce Points and Rewards
 */

namespace DDWCPointsAndRewards\Includes\Admin;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Admin_Hooks' ) ) {
	/**
	 * Admin end hook handler class
	 */
	class DDWCPR_Admin_Hooks extends DDWCPR_Admin_Functions {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			parent::__construct( $ddwcpr_configuration );

			add_filter( 'woocommerce_enable_admin_help_tab', '__return_false' );

			add_filter( 'admin_footer_text', [ $this, 'ddwcpr_set_admin_footer_text' ], 99 );

			add_action( 'admin_init', [ $this, 'ddwcpr_register_settings' ] );

			add_action( 'show_user_profile', [ $this, 'ddwcpr_add_custom_fields_in_user_data_form' ] );

			add_action( 'edit_user_profile', [ $this, 'ddwcpr_add_custom_fields_in_user_data_form' ] );

			add_action( 'personal_options_update', [ $this, 'ddwcpr_save_custom_fields_in_user_data' ] );

			add_action( 'edit_user_profile_update', [ $this, 'ddwcpr_save_custom_fields_in_user_data' ] );

			add_action( 'woocommerce_refund_created', [ $this, 'ddwcpr_handle_refund_created' ] );

			add_filter( 'tiny_mce_before_init', [ $this, 'ddwcpr_allow_svg_in_tinymce' ] );

			add_action( 'admin_notices', [ $this, 'ddwcpr_show_pro_upgrade_notice' ] );
		}
	}
}
