<?php
/**
 * This file handles all admin end ajax action hooks.
 *
 * @package WooCommerce Points and Rewards
 * @version 1.0.0
 */

namespace DDWCPointsAndRewards\Includes\Admin;

defined( 'ABSPATH' ) || exit();

if ( ! class_exists( 'DDWCPR_Admin_Ajax_Hooks' ) ) {
	/**
	 * Admin end ajax hook handler class
	 */
	class DDWCPR_Admin_Ajax_Hooks extends DDWCPR_Admin_Ajax_Functions {
		/**
		 * Construct
		 * 
		 * @param array $ddwcpr_configuration
		 */
		public function __construct( $ddwcpr_configuration ) {
			parent::__construct( $ddwcpr_configuration );

			add_action( 'wp_ajax_ddwcpr_batch_import_points', [ 'DDWCPointsAndRewards\Includes\DDWCPR_Import_Wizard', 'ajax_batch_import_points' ] );
			add_action( 'wp_ajax_ddwcpr_batch_manual_adjustment', [ $this, 'ddwcpr_batch_manual_adjustment' ] );
			add_action( 'wp_ajax_ddwcpr_get_all_users', [ $this, 'ddwcpr_get_all_users' ] );
		}
	}
}
