<?php
/**
 * Plugin Name: LoyaltyX - Points and Rewards for WooCommerce
 * Description: Reward customers with points for purchases and activities, redeemable for discounts, free products, and special rewards.
 * Plugin URI: https://devdiggers.com/woocommerce-points-and-rewards/?utm_source=LoyaltyX%20-%20Points%20and%20Rewards%20for%20WooCommerce&utm_medium=Plugins%20List&utm_campaign=WooCommerce%20Extensions
 * Author: DevDiggers
 * Author URI: https://devdiggers.com/
 * Version: 1.0.0
 * Text Domain: loyaltyx-points-and-rewards-for-woocommerce
 * Domain Path: /i18n
 * WC requires at least: 9.0.0
 * WC tested up to: 10.4.3
 * WP requires at least: 6.5.0
 * WP tested up to: 6.9.0
 * DevDiggersPrefix: ddwcpr
 * Requires Plugins: woocommerce
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package LoyaltyX - Points and Rewards for WooCommerce
 */

// ddwcpr: LoyaltyX - Points and Rewards for WooCommerce.
use DDWCPointsAndRewards\Includes\DDWCPR_File_Handler;

defined( 'ABSPATH' ) || exit();

// Define Constants.
defined( 'DDWCPR_PLUGIN_FILE' ) || define( 'DDWCPR_PLUGIN_FILE', plugin_dir_path( __FILE__ ) );
defined( 'DDWCPR_PLUGIN_URL' ) || define( 'DDWCPR_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
defined( 'DEVDIGGERS_FREE_PLUGIN' ) || define( 'DEVDIGGERS_FREE_PLUGIN', true );

if ( ! class_exists( 'DDWCPR_Free_Init' ) ) {
	/**
	 * Init class
	 */
	final class DDWCPR_Free_Init {
		/**
		 * Instance variable
		 *
		 * @var DDWCPR_Free_Init|null
		 */
		private static $_instance = null;

		/**
		 * Class constructor
		 */
		public function __construct() {
			add_action( 'init', [ $this, 'ddwcpr_init' ] );
			add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), [ $this, 'ddwcpr_plugin_settings_link' ] );
			add_filter( 'plugin_row_meta', [ $this, 'ddwcpr_plugin_row_meta' ], 10, 2 );
		}

		/**
		 * Create a plugin instance.
		 *
		 * @return static
		 * @since 1.0.0
		 */
		public static function get_instance() {
			if ( null === self::$_instance ) {
				self::$_instance = new self();

				/**
				 * Action hook fired when the main plugin instance is loaded.
				 *
				 * @since 1.0.0
				 */
				do_action( 'ddwcpr_loaded' );
			}

			return self::$_instance;
		}

		/**
		 * Init function
		 *
		 * @return void
		 */
		public function ddwcpr_init() {
			if ( ! class_exists( 'WooCommerce' ) ) {
				add_action( 'admin_notices', function () {
					?>
					<div class="error">
						<p>
							<?php
							/* translators: %1$s for a opening tag and %2$s for a closing tag */
							echo sprintf( esc_html__( 'LoyaltyX is activated but not effective. It requires %1$sWooCommerce Plugin%2$s in order to use its functionalities.', 'loyaltyx-points-and-rewards-for-woocommerce' ), '<a href="' . esc_url( '//wordpress.org/plugins/woocommerce/' ) . '" target="_blank">', '</a>' );
							?>
						</p>
					</div>
					<?php
				} );
			} else {
				require_once DDWCPR_PLUGIN_FILE . 'autoload/autoload.php';
				new DDWCPR_File_Handler();

				// Initialize review notice if framework is available.
				new \DevDiggers\Framework\Includes\DDFW_Review_Notice( [
					'plugin_name'   => esc_html__( 'LoyaltyX - Points and Rewards for WooCommerce', 'loyaltyx-points-and-rewards-for-woocommerce' ),
					'plugin_prefix' => 'ddwcpr',
					'review_url'    => 'https://wordpress.org/support/plugin/loyaltyx-points-and-rewards-for-woocommerce/reviews/#new-post',
				] );
			}
		}

		/**
		 * Plugin settings link
		 *
		 * @param array $links Links Array.
		 * @return array $links
		 */
		public function ddwcpr_plugin_settings_link( $links ) {
			ob_start();
			?>
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=ddwcpr-dashboard' ) ); ?>"><?php esc_html_e( 'Dashboard', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></a>
			|
			<a href="<?php echo esc_url( admin_url( 'admin.php?page=ddwcpr-dashboard&menu=ddwcpr-configuration' ) ); ?>"><?php esc_html_e( 'Configuration', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></a>
			|
			<a href="//devdiggers.com/plugin/woocommerce-points-and-rewards/?utm_source=plugin_link&utm_medium=upgrade_button&utm_campaign=plugin_upgrade" style="color: #0256ff; font-weight: bold;" target="_blank"><?php esc_html_e( 'Upgrade to Pro', 'loyaltyx-points-and-rewards-for-woocommerce' ); ?></a>
			<?php
			$new_links = ob_get_clean();
			array_unshift( $links, $new_links );
			return $links;
		}

		/**
		 * Plugin Doc link
		 *
		 * @param array  $links Links.
		 * @param string $file File name.
		 * @return array $links
		 */
		public function ddwcpr_plugin_row_meta( $links, $file ) {
			if ( plugin_basename( __FILE__ ) === $file ) {
				$row_meta = [
					'support'       => '<a href="//devdiggers.com/contact/" aria-label="' . esc_attr__( 'Support', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '">' . esc_html__( 'Support', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '</a>',
					'documentation' => '<a href="//devdiggers.com/knowledge-base/woocommerce-points-and-rewards/" aria-label="' . esc_attr__( 'Documentation', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '">' . esc_html__( 'Documentation', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '</a>',
					'review'        => '<a href="//devdiggers.com/plugin/woocommerce-points-and-rewards/" target="_blank" title="' . esc_attr__( 'Review', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '" aria-label="' . esc_attr__( 'Review', 'loyaltyx-points-and-rewards-for-woocommerce' ) . '"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 192 32" height="10"><path d="M16 26.534L6.111 32 8 20.422l-8-8.2 11.056-1.688L16 0l4.944 10.534L32 12.223l-8 8.2L25.889 32zm40 0L46.111 32 48 20.422l-8-8.2 11.056-1.688L56 0l4.944 10.534L72 12.223l-8 8.2L65.889 32zm40 0L86.111 32 88 20.422l-8-8.2 11.056-1.688L96 0l4.944 10.534L112 12.223l-8 8.2L105.889 32zm40 0L126.111 32 128 20.422l-8-8.2 11.056-1.688L136 0l4.944 10.534L152 12.223l-8 8.2L145.889 32zm40 0L166.111 32 168 20.422l-8-8.2 11.056-1.688L176 0l4.944 10.534L192 12.223l-8 8.2L185.889 32z" fill="#F5A623" fill-rule="evenodd"/></svg></a>',
				];
				$links = array_merge( $links, $row_meta );
			}

			return $links;
		}
	}
}

// Initialize the plugin.
if ( ! class_exists( 'DDWCPR_Init' ) ) {
	DDWCPR_Free_Init::get_instance();

	// Load DevDiggers Framework if not loaded already.
	add_action( 'plugins_loaded', function() {
		// Check if the plugin framework is already loaded.
		if ( ! defined( 'DDFW_LOADED' ) && file_exists( DDWCPR_PLUGIN_FILE . 'devdiggers-framework/init.php' ) ) {
			if ( ! empty( $_GET['page'] ) && 'ddwcpr-dashboard' === $_GET['page'] ) {
				require DDWCPR_PLUGIN_FILE . 'devdiggers-framework/init.php';
			} else {
				require DDWCPR_PLUGIN_FILE . 'devdiggers-framework/init.php';
			}
		}
	} );
}

// For HPOS Compatibility
add_action( 'before_woocommerce_init', function() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

require_once DDWCPR_PLUGIN_FILE . 'includes/install.php';
register_activation_hook( __FILE__, [ 'DDWCPR_Install', 'ddwcpr_on_plugin_activation' ] );
