<?php
/**
 * Simple layout template for the DevDiggers plugins.
 *
 * @author  DevDiggers
 * @category Framework
 * @package DevDiggers\Framework
 */

defined( 'ABSPATH' ) || exit(); // Exit if accessed directly.

$tabs = $current_menu_data[ 'tabs' ];
?>
<div class="ddfw-template-container">
	<?php
	if ( ! empty( $tabs ) && is_array( $tabs ) ) {
		$current_tab = ! empty( $_GET[ 'tab' ] ) ? sanitize_title( wp_unslash( $_GET[ 'tab' ] ) ) : array_key_first( $tabs );

		$callback = $tabs[ $current_tab ][ 'callback' ] ?? null;  // Get the callback for the current tab
		?>

		<!-- Mobile sidebar toggle button -->
		<button class="ddfw-mobile-sidebar-toggle" type="button" aria-label="<?php esc_attr_e( 'Toggle Sidebar', 'devdiggers-framework' ); ?>">
			<svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
				<path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"/>
			</svg>
		</button>

		<!-- Mobile sidebar overlay -->
		<div class="ddfw-mobile-sidebar-overlay"></div>

		<nav class="ddfw-left-tab-wrapper">
			<!-- Mobile sidebar close button -->
			<button class="ddfw-mobile-sidebar-close" type="button" aria-label="<?php esc_attr_e( 'Close Sidebar', 'devdiggers-framework' ); ?>">
				<svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
					<path d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"/>
				</svg>
			</button>

			<?php
			foreach ( $tabs as $key => $tab ) {
				?>
				<a href="<?php echo esc_url( admin_url( "admin.php?page={$page}&menu={$current_menu}&tab={$key}" ) ); ?>" class="ddfw-left-tab <?php echo esc_attr( $current_tab === $key ? 'ddfw-left-tab-active' : '' ); ?>">
					<?php
					if ( ! empty( $tab[ 'icon' ] ) ) {
						echo wp_kses( $tab[ 'icon' ], array_merge( wp_kses_allowed_html( 'post' ), ddfw_kses_allowed_svg_tags() ) );
					}
					echo esc_html( $tab[ 'label' ] ); ?>
				</a>
				<?php
			}
			?>
		</nav>
		<div class="ddfw-template-wrapper ddfw-configuration-wrapper">
			<?php
			if ( is_callable( $callback ) ) {
				call_user_func( $callback );
			}
			?>
		</div>
		<?php
	}
	?>
</div>
