<?php
/**
 * File for handling the header of the DevDiggers Plugin Framework.
 *
 * @author  DevDiggers
 * @category Framework
 * @package DevDiggers\Framework
 */

use DevDiggers\Framework\Includes\DDFW_SVG;

defined( 'ABSPATH' ) || exit(); // Exit if accessed directly.

?>
<nav class="ddfw-header-tab-wrapper">
	<div class="ddfw-header-tabs-list-wrapper">
		<div class="ddfw-plugin-name">
			<?php echo wp_kses( $this->args[ 'plugin_name' ], array_merge( wp_kses_allowed_html( 'post' ), ddfw_kses_allowed_svg_tags() ) ); ?>
		</div>
		<?php

		$count       = 1;
		$show_menus  = 10;
		$total_menus = count( $menus );

		?>
		<ul class="ddfw-header-tabs">
			<?php
			foreach ( $menus as $slug => $menu ) {
				if ( $count < $show_menus ) {
					?>
					<li class="ddfw-header-tab <?php echo esc_attr( $current_menu === $slug ? 'ddfw-header-tab-active' : '' ); ?>">
						<a href="<?php echo esc_url( admin_url( "admin.php?page={$page}&menu={$slug}" ) ); ?>"><?php echo esc_html( $menu[ 'label' ] ); ?></a>
					</li>
					<?php
				} else {
					if ( $show_menus === $count ) {
						?>
						<li class="ddfw-header-tab"><a href="#"><?php esc_html_e( 'More', 'devdiggers-framework' ); ?><span class="dashicons dashicons-arrow-down-alt2"></span></a>
						<ul class="ddfw-header-dropdown">
							<li class="ddfw-header-tab <?php echo esc_attr( $current_menu === $slug ? 'ddfw-header-tab-active' : '' ); ?>"><a href="<?php echo esc_url( admin_url( "admin.php?page={$page}&menu={$slug}" ) ); ?>"><?php echo esc_html( $menu[ 'label' ] ); ?></a></li>
						<?php
					} else {
						?>
						<li class="ddfw-header-tab <?php echo esc_attr( $current_menu === $slug ? 'ddfw-header-tab-active' : '' ); ?>"><a href="<?php echo esc_url( admin_url( "admin.php?page={$page}&menu={$slug}" ) ); ?>"><?php echo esc_html( $menu[ 'label' ] ); ?></a></li>
						<?php
					}

					if ( $total_menus === $count ) {
						?>
						</ul></li>
						<?php
					}
				}
				++$count;
			}
			?>
		</ul>
		<div class="ddfw-upgrade-to-pro-button-wrapper">
			<?php
			if ( ! empty( $this->args[ 'upgrade_url' ] ) ) {
				?>
				<a href="<?php echo esc_url( $this->args[ 'upgrade_url' ] ); ?>" target="_blank" class="ddfw-upgrade-to-pro-button">
					<?php
					DDFW_SVG::get_svg_icon(
						'crown',
						false,
						[ 'size' => 15 ]
					);
					?>
					<?php esc_html_e( 'Upgrade to Pro', 'devdiggers-framework' ); ?>
				</a>
				<?php
			}
			?>
		</div>
	</div>
</nav>
