# LoyaltyX

**Contributors:** DevDiggers  
**Plugin URI:** https://devdiggers.com/woocommerce-extensions/  
**Author:** DevDiggers  
**Author URI:** https://devdiggers.com/  
**Version:** 1.0.0  
**License:** GNU General Public License v3.0  
**License URI:** http://www.gnu.org/licenses/gpl-3.0.html

**WordPress Requirements:**
- Requires at least: 6.5
- Tested up to: 6.9

**WooCommerce Requirements:**
- Requires at least: 9.0.0
- Tested up to: 10.4.3

---

## Description

**LoyaltyX - Points and Rewards for WooCommerce** is a comprehensive customer loyalty plugin that rewards customers with points for purchases and activities. Customers can redeem points for discounts, free products, and special rewards, creating an incentive system that drives repeat purchases and engagement.

---

## Key Features

### 🎁 Points Earning
- **Purchase Amount** - Points based on order total
- **Product Purchase** - Bonus points for specific products (Pro)
- **Referral Program** - Reward for referring others (Pro)
- **Signup Bonus** - Points for new account creation (Pro)
- **Review Submissions** - Points for product reviews (Pro)
- **Daily Login** - Daily engagement rewards (Pro)
- **Birthday Points** - Special birthday rewards (Pro)
- **Level-Up Points** - Bonus points for reaching loyalty levels (Pro)

### 🎯 Points Redemption
- **Points Conversion** - Convert points to store credit
- **Fixed Discount** - Preset rewards (e.g., 500 points = $50) (Pro)
- **Percentage Discount** - Percentage-based discounts (Pro)
- **Buy X Get Y** - Special product deals (Pro)
- **Bundle Rewards** - Exclusive product bundles (Pro)
- **Free Shipping** - Points for free shipping (Pro)
- **Free Products** - Exchange points for free items (Pro)

### ⏰ Points Management
- Automatic point expiration
- Expiring points notifications
- Points history tracking
- Manual points adjustment

### 📊 Customer Dashboard
- Points balance display
- Transaction history
- Available rewards catalog
- Referral tracking
- Expiring points alerts

### ⚙️ Admin Features
- User points management
- Import/export via CSV
- Email notification templates
- Comprehensive reporting
- Flexible rule configuration

### 🔧 Technical Features
- HPOS compatible
- Shortcode support
- Multilingual ready
- REST API endpoints
- Background processing

---

## Installation

### Automatic Installation
1. Go to **Plugins > Add New** in WordPress admin
2. Search for "LoyaltyX - Points and Rewards for WooCommerce"
3. Click **Install Now** then **Activate**

### Manual Installation
1. Download the plugin zip file
2. Upload to `/wp-content/plugins/` directory
3. Activate through **Plugins** menu

### After Installation
1. Navigate to **DevDiggers Plugins > LoyaltyX** in admin menu.
2. Configure earning and redemption rules.
3. Set up email notifications.
4. Customize point labels and messages.

---

## Configuration

### Points Earning Setup
1. Go to **DevDiggers Plugins > LoyaltyX > Configuration > Points Earning**
2. Set conversion rate (e.g., $1 = 10 points)
3. Configure eligible products/categories
4. Enable additional earning rules

### Points Redemption Setup
1. Go to **DevDiggers Plugins > LoyaltyX > Configuration > Points Redemption**
2. Set redemption rate (e.g., 100 points = $10)
3. Configure minimum/maximum limits
4. Set up redemption rules

### Creating Rules
1. Go to **DevDiggers Plugins > LoyaltyX > Points Rules**
2. Click **Add New Rule**
3. Select rule type and configure conditions
4. Set status to Active and save

---

## Usage

### For Customers
- Earn points through purchases and activities
- View points balance in My Account
- Redeem points for rewards using generated coupons
- Track points history and expiring points

### For Store Owners
- Monitor customer points from admin dashboard
- Manually adjust points when needed
- View reports and analytics
- Manage rules and configurations

---

## Frequently Asked Questions

**How do customers earn points?**
Customers earn points through purchases, reviews, referrals, signups, and other configured activities.

**Do points expire?**
Points expiration is optional. Configure expiration periods and notification settings in the admin.

**Can I import existing points?**
Yes, use the Import feature to bulk import customer points via CSV.

**Are points refunded on order cancellation?**
Yes, points are automatically deducted when orders are cancelled, failed, or refunded.

---

## Support

- **Documentation:** [Knowledge Base](https://devdiggers.com/knowledge-base/woocommerce-points-and-rewards/)
- **Support:** [Contact Form](https://devdiggers.com/contact/)
- **Email:** support@devdiggers.com

---

## Changelog

### Version 1.0.0
- Initial release with complete points system
- Earning and redemption rules
- Customer dashboard and admin tools
- Email notifications and reporting
- HPOS compatibility and multilingual support

---

## About DevDiggers

DevDiggers creates high-quality WordPress and WooCommerce solutions. Visit [DevDiggers.com](https://devdiggers.com/) for more plugins and extensions.
