<?php
/** 
 * Logtastic
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name: 	Logtastic
 * Plugin URI:		https://logtastic.net/
 * Description:		Logging plugin for WordPress. Logs PHP errors, JavaScript errors, and more coming soon.
 * Version:			1.0.0
 * Author:			Inspired Plugins
 * Author URI:		https://inspiredplugins.com/
 * License:			GPL v2 or later
 * License URI:		https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: 	logtastic
 */

namespace Inspired_Plugins\Logtastic;


// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


// Define plugin full name constant.
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_FULL_NAME', 'Logtastic' );

// Define plugin short name / slug constant.
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_SLUG', 'logtastic' );

// Define plugin options name constant.
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_OPTIONS_NAME', 'logtastic_settings' );

// Define plugin version constant.
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_VERSION', '1.0.0' );

// Define plugin feature version constant.
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_FEATURE_VERSION', 'free' );

// Define plugin filename
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_FILE_NAME', basename( __FILE__ ) );

// Define plugin filepath
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_FILE_PATH', __FILE__ );

// Define plugin directory path
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );

// Define plugin directory url
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_DIR_URL', plugins_url( LOGTASTIC_PLUGIN_SLUG ) );

// Define MU Loader File Name
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_MU_LOADER_FILE_NAME', '000-logtastic-loader.php' );

// Define Plugin URL
define( __NAMESPACE__ . '\LOGTASTIC_PLUGIN_URL', 'https://logtastic.net?utm_source=plugin-free' );


// Plugin activation function
function activate_logtastic() {
	
	require_once LOGTASTIC_PLUGIN_DIR_PATH . 'includes/class-logtastic-activator.php';
	$activator = new Logtastic_Activator;
	$activator->activate( LOGTASTIC_PLUGIN_OPTIONS_NAME );
	
}
register_activation_hook( LOGTASTIC_PLUGIN_FILE_PATH , __NAMESPACE__ . '\activate_logtastic' );


// Plugin deactivation function
function deactivate_logtastic() {
	
	require_once LOGTASTIC_PLUGIN_DIR_PATH . 'includes/class-logtastic-deactivator.php';
	$deactivator = new Logtastic_Deactivator;
	$deactivator->deactivate();
	
}
register_deactivation_hook( LOGTASTIC_PLUGIN_FILE_PATH , __NAMESPACE__ . '\deactivate_logtastic' );


// Plugin uninstall function 
function uninstall_logtastic() {

	// Get list of custom database tables used by the plugin
	require_once LOGTASTIC_PLUGIN_DIR_PATH . 'includes/utilities/class-logtastic-db-utilities.php';
	$db_utilities = new Logtastic_DB_Utilities();
	$tables_to_delete = $db_utilities->list_all_db_tables();
	
	// Load the uninstaller
	require_once LOGTASTIC_PLUGIN_DIR_PATH . 'includes/class-logtastic-uninstaller.php';
	$uninstaller = new Logtastic_Uninstaller;

	// Run the uninstall actions
	$uninstaller->uninstall( $tables_to_delete );

}
register_uninstall_hook( LOGTASTIC_PLUGIN_FILE_PATH , __NAMESPACE__ . '\uninstall_logtastic' );

// Load the core plugin class
require LOGTASTIC_PLUGIN_DIR_PATH . 'includes/class-logtastic.php';


// Begin plugin execution
function run_logtastic() {
	$plugin = new Logtastic();
	$plugin->run();
}

run_logtastic();