<?php
/**
 * The default settings for the plugin.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */

namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Logtastic_Default_Settings {
	
	public static $default_settings_general = [
		'logtastic_initial_setup_completed' =>	false,
		'enabled_logs' 	=>	[
			'php-error-log'	=> false,
			'js-error-log'	=> false,
		],
		'logtastic_installed_version'	=> LOGTASTIC_PLUGIN_FEATURE_VERSION . '_' . LOGTASTIC_PLUGIN_VERSION,
		'access_roles' =>	[
			'administrator',
		],
		'loading_method' =>	'standard',
	];
	
	public static $default_settings_php_error_log = [
		'error_levels' 					=>	[ 'e_error', 'e_parse', 'e_user_error' ],
		'scope_wp_core' 				=>	true,
		'scope_wp_themes' 				=>	'all',
		'scope_wp_plugins'				=>	'all',
		'capture_stacktrace'			=>	0,
		'capture_stacktrace_args'		=>	0,
		'retention_schedule'			=>	0,
		'disable_default_error_handler'	=>	1
	];
	
	public static $default_settings_js_error_log = [
		'error_types' 					=>	[ '1', '2' ],
		'scope_wp_core' 				=>	true,
		'scope_wp_themes' 				=>	'all',
		'scope_wp_plugins'				=>	'all',
		'capture_stacktrace'			=>	0,
		'capture_session_info'			=>	0,
		'retention_schedule'			=>	0
	];
	
	public static $default_settings_mail_log = [
		
	];
	
	public static $db_structure = [
		// PHP Error Log
		'php-error-log'			=> [
			// PHP Error Log - Errors Table
			'logtastic_php_errors' => [	
				// Unique ID
				'error_id'			=>	[
										'data_type'			=>	'BIGINT',
										'length'			=>	20,
										'unsigned'			=>	true,
										'allow_null'		=>	false,
										'auto_increment'	=>	true,
										'default'			=>	false,
										'unique'			=> 	true,
										'primary_key'		=>	true,
				],
				// Error Level - eg. E_ERROR, E_WARNING
				'error_level'		=>	[
										'data_type'			=>	'VARCHAR',
										'length'			=>	25,
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// File path - eg. home/public_html/example.php
				'file'				=>	[
										'data_type'			=>	'TEXT',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Line - line number on which error occured
				'line'				=>	[
										'data_type'			=>	'INT',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Source - Theme / Plugin / Core / Rest API / Unknown
				'source'			=>	[
										'data_type'			=>	'VARCHAR',
										'length'			=>	25,
										'allow_null'		=>	true,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Source Slug - Theme, Plugin or API slug
				'source_slug'		=>	[
										'data_type'			=>	'TEXT',
										'allow_null'		=>	true,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				'message'			=>	[
										'data_type'			=>	'TEXT',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Timestamp
				'timestamp' 		=>	[
										'data_type'			=>	'DATETIME',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				'additional_data'	=>	[
										'data_type'			=>	'LONGTEXT',
										'allow_null'		=>	true,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Ignore Flag - 1 = ignore, 0 = don't ignore
				'ignore_error'		=>	[
										'data_type'			=>	'TINYINT',
										'unsigned'			=>	true,
										'allow_null'		=>	false,
										'default'			=>	0,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
			],
			// PHP Error Log - Occurrences Table
			'logtastic_php_error_occurrences' => [	
				// Unique ID
				'occurrence_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	false,
					'auto_increment'	=>	true,
					'default'			=>	false,
					'unique'			=> 	true,
					'primary_key'		=>	true,
				],
				// Error ID
				'error_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	false,
					'auto_increment'	=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Source Version (000 000 000)
				'source_version' =>	[
					'data_type'			=>	'VARCHAR',
					'length'			=>	9,
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// WordPress Version (000 000 000)
				'wp_version' =>	[
					'data_type'			=>	'VARCHAR',
					'length'			=>	9,
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// PHP Version (000 000 000)
				'php_version' =>	[
					'data_type'			=>	'VARCHAR',
					'length'			=>	9,
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Timestamp
				'timestamp' =>	[
					'data_type'			=>	'DATETIME',
					'allow_null'		=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace Array ID
				'stack_trace_array_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	true,
					'auto_increment'	=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace String ID
				'stack_trace_string_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	true,
					'auto_increment'	=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace Available
				'stack_trace_available'	=>	[
					'data_type'			=>	'TINYINT',
					'length'			=>	1,
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Logging Method
				'method'			=>	[
					'data_type'			=>	'TINYTEXT',
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				'additional_data'	=>	[
					'data_type'			=>	'LONGTEXT',
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
			],
			// PHP Error Log - Stack Traces Table
			'logtastic_php_error_stack_traces' => [	
				// Unique ID
				'stack_trace_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	false,
					'auto_increment'	=>	true,
					'default'			=>	false,
					'unique'			=> 	true,
					'primary_key'		=>	true,
				],
				// Error ID
				'error_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	false,
					'auto_increment'	=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace Type
				'stack_trace_type' =>	[
					'data_type'			=>	'TINYTEXT',
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace Data
				'stack_trace_data'	=>	[
					'data_type'			=>	'LONGTEXT',
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
			],
		],
		// JS Error Log
		'js-error-log'			=> [
			// JS Error Log - Errors Table
			'logtastic_js_errors' => [	
				// Unique ID
				'error_id'			=>	[
										'data_type'			=>	'BIGINT',
										'length'			=>	20,
										'unsigned'			=>	true,
										'allow_null'		=>	false,
										'auto_increment'	=>	true,
										'default'			=>	false,
										'unique'			=> 	true,
										'primary_key'		=>	true,
				],
				// Error Level - eg. 1 = Runtime error, 2 = Unhandled promise rejection
				'error_type'		=>	[
										'data_type'			=>	'VARCHAR',
										'length'			=>	1,
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// File - eg. https://example.com/example.js
				'file'				=>	[
										'data_type'			=>	'TEXT',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Line - line number on which error occurred
				'line'				=>	[
										'data_type'			=>	'INT',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Column - column number on which error occurred
				'col'				=>	[
										'data_type'			=>	'INT',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Source - Theme / Plugin / Core / Rest API / Unknown
				'source'			=>	[
										'data_type'			=>	'VARCHAR',
										'length'			=>	25,
										'allow_null'		=>	true,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Source Slug - Theme, Plugin or API slug
				'source_slug'		=>	[
										'data_type'			=>	'TEXT',
										'allow_null'		=>	true,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				'message'			=>	[
										'data_type'			=>	'TEXT',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Timestamp
				'timestamp' 		=>	[
										'data_type'			=>	'DATETIME',
										'allow_null'		=>	false,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				'additional_data'	=>	[
										'data_type'			=>	'LONGTEXT',
										'allow_null'		=>	true,
										'default'			=>	false,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
				// Ignore Flag - 1 = ignore, 0 = don't ignore
				'ignore_error'		=>	[
										'data_type'			=>	'TINYINT',
										'unsigned'			=>	true,
										'allow_null'		=>	false,
										'default'			=>	0,
										'unique'			=> 	false,
										'primary_key'		=>	false,
				],
			],
			// JS Error Log - Occurrences Table
			'logtastic_js_error_occurrences' => [	
				// Unique ID
				'occurrence_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	false,
					'auto_increment'	=>	true,
					'default'			=>	false,
					'unique'			=> 	true,
					'primary_key'		=>	true,
				],
				// Error ID
				'error_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	false,
					'auto_increment'	=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Source Version (000 000 000)
				'source_version' =>	[
					'data_type'			=>	'VARCHAR',
					'length'			=>	9,
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// WordPress Version (000 000 000)
				'wp_version' =>	[
					'data_type'			=>	'VARCHAR',
					'length'			=>	9,
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// PHP Version (000 000 000)
				'php_version' =>	[
					'data_type'			=>	'VARCHAR',
					'length'			=>	9,
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Timestamp
				'timestamp' =>	[
					'data_type'			=>	'DATETIME',
					'allow_null'		=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace Array ID
				'stack_trace_array_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	true,
					'auto_increment'	=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace String ID
				'stack_trace_string_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	true,
					'auto_increment'	=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace Available
				'stack_trace_available'	=>	[
					'data_type'			=>	'TINYINT',
					'length'			=>	1,
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Logging Method
				'method'			=>	[
					'data_type'			=>	'TINYTEXT',
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				'url'			=>	[
					'data_type'			=>	'TEXT',
					'allow_null'		=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				'user_agent'	=>	[
					'data_type'			=>	'TEXT',
					'allow_null'		=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				'additional_data'	=>	[
					'data_type'			=>	'LONGTEXT',
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
			],
			// JS Error Log - Stack Traces Table
			'logtastic_js_error_stack_traces' => [	
				// Unique ID
				'stack_trace_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	false,
					'auto_increment'	=>	true,
					'default'			=>	false,
					'unique'			=> 	true,
					'primary_key'		=>	true,
				],
				// Error ID
				'error_id' =>	[
					'data_type'			=>	'BIGINT',
					'length'			=>	20,
					'unsigned'			=>	true,
					'allow_null'		=>	false,
					'auto_increment'	=>	false,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace Type
				'stack_trace_type' =>	[
					'data_type'			=>	'TINYTEXT',
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
				// Stack Trace Data
				'stack_trace_data'	=>	[
					'data_type'			=>	'LONGTEXT',
					'allow_null'		=>	true,
					'default'			=>	false,
					'unique'			=> 	false,
					'primary_key'		=>	false,
				],
			],
		],
	];
	
	public static $php_error_levels = [
		E_ERROR => "e_error",
		E_WARNING => "e_warning",
		E_PARSE => "e_parse",
		E_NOTICE => "e_notice",
		E_CORE_ERROR => "e_core_error",
		E_CORE_WARNING => "e_core_warning",
		E_COMPILE_ERROR => "e_compile_error",
		E_COMPILE_WARNING => "e_compile_warning",
		E_USER_ERROR => "e_user_error",
		E_USER_WARNING => "e_user_warning",
		E_USER_NOTICE => "e_user_notice",
		E_RECOVERABLE_ERROR => "e_recoverable_error",
		E_DEPRECATED => "e_deprecated",
		E_USER_DEPRECATED => "e_user_deprecated",
		E_ALL => "e_all"
	];

	public static function get_admin_page_definitions(): array {
		return [
			'logtastic'	=> [
				'page-title' 				=> LOGTASTIC_PLUGIN_FULL_NAME,
				'menu-title'				=> LOGTASTIC_PLUGIN_FULL_NAME,
				'icon' 						=> 'dashicons-list-view',
				'callback' 					=> 'admin_page_home',
				'required_capability'		=> 'read',
				'position' 				 	=> 200,
				'permission-requirements'	=> ['php-error-log-view', 'js-error-log-view', 'plugin-settings'],
				'sub_pages' 				=> [
					'logtastic_php-error-log' => [
						'page-title'				=> __( 'PHP Error Log', 'logtastic' ),
						'menu-title' 				=> __( 'PHP Error Log', 'logtastic' ),
						'callback' 					=> 'admin_page_php_error_log',
						'required_capability'		=> 'read',
						'enabled_setting'			=> 'php-error-log',
						'permission-requirements'	=> ['php-error-log-view'],
					],
					'logtastic_js-error-log' => [
						'page-title'				=> __( 'JavaScript Error Log', 'logtastic' ),
						'menu-title' 				=> __( 'JS Error Log', 'logtastic' ),
						'callback' 					=> 'admin_page_js_error_log',
						'required_capability' 		=> 'read',
						'enabled_setting'			=> 'js-error-log',
						'permission-requirements'	=> ['js-error-log-view'],
					],
					'logtastic_settings' => [
						'page-title'				=> __( 'Settings', 'logtastic' ),
						'menu-title' 				=> __( 'Settings', 'logtastic' ),
						'callback'					=> 'admin_page_settings',
						'required_capability' 		=> 'read',
						'permission-requirements'	=> ['plugin-settings'],
					],
					'logtastic_help' => [
						'page-title'				=> __( 'Help &amp; Support', 'logtastic' ),
						'menu-title' 				=> __( 'Help &amp; Support', 'logtastic' ),
						'callback' 					=> 'admin_page_help',
						'required_capability' 		=> 'read',
						'permission-requirements'	=> [],
					],
				],
			],
		];
	}
	
}