<?php

/**
 * The functonality required during plugin uninstallation
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */

namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


class Logtastic_Uninstaller {
	

	/**
	 * Delete plugin options
	 *
	 * @since    1.0.0
	 */
	public function delete_options() {
		
		// Delete Main Plugin Options
		delete_option( LOGTASTIC_PLUGIN_OPTIONS_NAME );
		
		// Delete PHP Error Log Settings
		delete_option( LOGTASTIC_PLUGIN_OPTIONS_NAME . '_php_error_log' );

		// Delete JS Error Log Settings
		delete_option( LOGTASTIC_PLUGIN_OPTIONS_NAME . '_js_error_log' );
		
	}
	

	/**
	 * Delete plugin custom tables from the database.
	 *
	 * @since    1.0.0
	 * @param    array                $table_names          An array of table_names to be deleted from the database.
	 */
	public function delete_db_tables( $table_names ) {
		
		global $wpdb;
		
		foreach ($table_names as $table_name) {
			
			// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
			$wpdb->query( $wpdb->prepare( "DROP TABLE IF EXISTS %i", $wpdb->prefix . $table_name ) );

		}
		
	}

	
	/**
	 * The main uninstall function for this plugin.
	 *
	 * @since    1.0.0
	 * @param    array                $table_names          An array of table_names to be deleted from the database.
	 */
	public function uninstall( $table_names ) {
		
		// Delete plugin options
		$this->delete_options();
		
		// Delete plugin custom tables
		$this->delete_db_tables( $table_names );
		
		// Remove MU Loader File
		wp_delete_file( WPMU_PLUGIN_DIR . '/' . LOGTASTIC_PLUGIN_MU_LOADER_FILE_NAME );	
		
	}
	
}

