<?php

/**
 * The functonality required during plugin deactivation
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */

namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 */
class Logtastic_Deactivator {
	

	/**
	 * This function is called during plugin deactivation.
	 *
	 * @since      1.0.0
	 */
	public function deactivate() {
		
		// Set autoload to false for plugin options
		wp_set_option_autoload( LOGTASTIC_PLUGIN_OPTIONS_NAME, false);
		
		// Remove scheduled task php error log retention schedule
		$scheduled_timestamp = wp_next_scheduled( 'logtastic_scheduled_task_process_php_error_log_retention_schedule' );
		if ( $scheduled_timestamp ) {
			wp_unschedule_event( $scheduled_timestamp, 'logtastic_scheduled_task_process_php_error_log_retention_schedule' );
		}
		
		// Remove scheduled task js error log retention schedule
		$scheduled_timestamp = wp_next_scheduled( 'logtastic_scheduled_task_process_js_error_log_retention_schedule' );
		if ( $scheduled_timestamp ) {
			wp_unschedule_event( $scheduled_timestamp, 'logtastic_scheduled_task_process_js_error_log_retention_schedule' );
		}
		
	}
	
}

