<?php
/**
 * The admin page to display the security and visibile settings page for the plugin.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */
 
namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<div class="settings-section-body">
		
	<h3 class="logtastic-admin-section-title"><?php esc_html_e( 'Plugin Access &amp; Visibility', 'logtastic' ); ?></h3>
	
	<p><?php esc_html_e( 'Choose which user roles can access the logs and plugin settings.', 'logtastic' ); ?></p>

	<hr>



	<form method="post" data-form-conditional="true">
		
		<input type="hidden" id="_wpnonce" name="_wpnonce" value="<?php echo esc_attr( $settings_nonce ); ?>">
		<input type="hidden" id="action" name="action" value="update-settings">

		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row"><?php esc_html_e( 'Select roles', 'logtastic' ); ?></th>

					<td>
						<fieldset>
							
							<legend class="screen-reader-text"><span><?php esc_html_e( 'Error Levels', 'logtastic' ); ?></span></legend>
							
							<p><?php esc_html_e( 'Select which user roles can access the logs and settings', 'logtastic' ); ?>:</p>
							<br>

							<?php foreach ( $roles as $logtastic_slug => $logtastic_role ) : ?>

								<label for="access_role_<?php echo esc_attr( $logtastic_slug ); ?>" class="logtastic-admin-settings-label-225">
									<input 
										name="access_roles[]" 
										type="checkbox" 
										id="access_role_<?php echo esc_attr( $logtastic_slug ); ?>" 
										value="<?php echo esc_attr( $logtastic_slug ); ?>" 
										<?php checked( in_array( $logtastic_slug, (array) $this->settings['access_roles'], true ) ); ?>
									>
									<?php echo esc_html( translate_user_role( $logtastic_role['name'] ) ); ?>
								</label>

								<br>

							<?php endforeach; ?>
						
						</fieldset>

					</td>
				</tr>
			</tbody>
		</table>

		<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', 'logtastic' ); ?>"></p>

	</form>


	<a class="pro-upgrade-banner" href="<?php echo esc_url( LOGTASTIC_PLUGIN_URL ); ?>" target="_blank">
		<h3><?php esc_html_e( 'Unlock greater functionality with Logtastic Pro', 'logtastic' ); ?></h3>
		<p><?php esc_html_e( 'Upgrade to Logtastic Pro to unlock more granular security & visibility settings, including:', 'logtastic' ); ?></p>
		<ul>
			<li><?php esc_html_e( 'Configure access settings individually for each log and plugin settings.', 'logtastic' ); ?></li>
			<li><?php esc_html_e( 'For each log, configure which users can access the log, as well as which users can edit or delete items.', 'logtastic' ); ?></li>
			<li><?php esc_html_e( 'Define access by user role and/or grant access to individual users.', 'logtastic' ); ?></li>
			<li><?php esc_html_e( 'Hide Logtastic from the plugins list for users without access.', 'logtastic' ); ?></li>
		</ul>
	</a>
	
</div>
