<?php
/**
 * The admin page to display the plugin's general settings page.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */
 
namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<div class="settings-section-body">
		
	<h3 class="logtastic-admin-section-title"><?php esc_html_e( 'General Settings', 'logtastic' ); ?></h3>
	
	<p><?php esc_html_e( 'Configure the general plugin settings.', 'logtastic' ); ?></p>

	<hr>

	<form method="post" data-form-conditional="true">
		
		<input type="hidden" id="_wpnonce" name="_wpnonce" value="<?php echo esc_attr( $settings_nonce ); ?>">
		<input type="hidden" id="action" name="action" value="update-settings">

		<table class="form-table" role="presentation">
			<tbody>
				<tr>
					<th scope="row"><?php esc_html_e( 'Plugin loading method', 'logtastic' ); ?></th>

					<td>
						<fieldset>
							
							<legend class="screen-reader-text"><span><?php esc_html_e( 'Plugin loading method', 'logtastic' ); ?></span></legend>
							
							<p><?php esc_html_e( 'Select the method used to load the plugin', 'logtastic' ); ?>:</p>
							<br>

							<div class="settings-form-flex">
								<div>
									<input 
										type="radio" 
										id="loading_method_standard" 
										name="loading_method" 
										value="standard"
										<?php checked( isset( $this->settings['loading_method'] ) && $this->settings['loading_method'] == 'standard', true ); ?>
									>
								</div>
								<div>
									<label class="logtastic-admin-php-error-type-label" for="loading_method_standard"><?php esc_html_e( 'Standard loading', 'logtastic' ); ?></label>
									<p class="explanation"><?php esc_html_e( 'The Logtastic plugin will be loaded in the standard sequence.', 'logtastic' ); ?></p>
									<p class="explanation"><?php esc_html_e( 'As plugins are loaded in alphabetical order, depending on which other plugins you have installed, it is likely that a number of other plugins may be loaded before the Logtastic plugin. As the Logtastic plugin will not be loaded until after those plugins, Logtastic would not be able to capture any errors those plugins may generate during loading.', 'logtastic' ); ?></p>
								</div>
							</div>
							<br>

							<div class="settings-form-flex">
								<div>
									<input 
										type="radio" 
										id="loading_method_priority" 
										name="loading_method" 
										value="priority"
										<?php checked( isset( $this->settings['loading_method'] ) && $this->settings['loading_method'] == 'priority', true ); ?>
									>
								</div>
								<div>
									<label class="logtastic-admin-php-error-type-label" for="loading_method_priority"><?php esc_html_e( 'Priority loading (recommended)', 'logtastic' ); ?></label>
									<p class="explanation"><?php esc_html_e( 'The Logtastic plugin will be loaded as a must-use plugin.', 'logtastic' ); ?></p>
									<p class="explanation"><?php esc_html_e( 'A file will be created in the "mu-plugins" directory, called "000-logtastic-loader.php" which will load the plugin.', 'logtastic' ); ?></p>
									<p class="explanation"><?php esc_html_e( 'This means that, in the majority of cases, the Logtastic plugin will be loaded before all other standard and must-use plugins. This improves the accuracy of logging operations by ensuring that logging functionality is loaded before other plugins are loaded, for example, it will allow the PHP error log to capture parse errors or other errors that occur during the loading process of other plugins that would otherwise be missed.', 'logtastic' ); ?></p>
									<p class="explanation"><?php esc_html_e( 'Note: unlinke traditional must-use plugins, the loader file will still respect the plugins activation status, meaning the plugin can still be decativated from the manage plugins page.', 'logtastic' ); ?></p>
								</div>
							</div>								
							<br>
						
						</fieldset>

					</td>
				</tr>
			</tbody>
		</table>

		<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', 'logtastic' ); ?>"></p>

	</form>

</div>