<?php
/**
 * The admin page to display the plugin's enable/disable logs settings page.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */
 
namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<h3 class="logtastic-admin-section-title"><?php esc_html_e( 'Enable/Disable Logs', 'logtastic' ); ?></h3>

<p><?php esc_html_e( 'Choose which logs to enable on your site. After enabling, you will be able to further configure each log.', 'logtastic' ); ?></p>

<table class="form-table widefat logtastic-enable-disable-logs-table">

	<thead>
		<tr>
			<th class="name" colspan="2"><?php esc_html_e( 'Log Name', 'logtastic' ); ?></th>
			<th class="description"><?php esc_html_e( 'Description', 'logtastic' ); ?></th>
			<th class="status"><?php esc_html_e( 'Enabled', 'logtastic' ); ?></th>
			<th class="action"></th>
		</tr>
	</thead>

	<tbody>
		
		<tr data-log-id="php-error-log" data-log-enabled-option-id="logtastic_php_error_logging_enabled" data-log-name="<?php esc_html_e( 'PHP Error Log', 'logtastic' ); ?>" class="<?php if ( ! empty( $this->settings['enabled_logs']['php-error-log'] ) ) { ?>enabled<?php } else { ?>disabled<?php } ?>">
			<td class="logo">
				<img src="<?php echo esc_url( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/php-logo.svg" alt="PHP Logo" />
			</td>
			<td class="name"><?php esc_html_e( 'PHP Error Log', 'logtastic' ); ?></td>
			<td class="description">
				<p><?php esc_html_e( 'The PHP Error Log will log all PHP errors encountered on your WordPress site.', 'logtastic' ); ?></p>
			</td>
			<td class="status" data-colname="<?php esc_attr_e( 'Enabled', 'logtastic' ); ?>">
				<button class="logtastic-toggle-switch<?php if ( ! empty( $this->settings['enabled_logs']['php-error-log'] ) ) { ?> enabled<?php } else { ?> disabled<?php } ?>" data-logtastic-action="enable-disable-log" data-nonce="<?php echo esc_attr( wp_create_nonce('enable-disable-log') ); ?>"></button>
			</td>
			<td class="action">
				<a class="button alignright" href="admin.php?page=logtastic_settings&tab=php-error-log"><?php esc_html_e( 'Settings', 'logtastic' ); ?></a>
			</td>
		</tr>
		
		<tr data-log-id="js-error-log" data-log-enabled-option-id="logtastic_js_error_logging_enabled" data-log-name="<?php esc_html_e( 'JavaScript Error Log', 'logtastic' ); ?>" class="<?php if ( ! empty( $this->settings['enabled_logs']['js-error-log'] ) ) { ?>enabled<?php } else { ?>disabled<?php } ?>">
			<td class="logo">
				<img src="<?php echo esc_url( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/js-logo.png" alt="JavaScript Logo" />
			</td>
			<td class="name"><?php esc_html_e( 'JavaScript Error Log', 'logtastic' ); ?></td>
			<td class="description">
				<p><?php esc_html_e( 'The JavaScript Error Log will log all JavaScript errors encountered on your WordPress site.', 'logtastic' ); ?></p>
			</td>
			<td class="status" data-colname="<?php esc_attr_e( 'Enabled', 'logtastic' ); ?>">
				<button class="logtastic-toggle-switch<?php if ( ! empty( $this->settings['enabled_logs']['js-error-log'] ) ) { ?> enabled<?php } else { ?> disabled<?php } ?>" data-logtastic-action="enable-disable-log" data-nonce="<?php echo esc_attr( wp_create_nonce('enable-disable-log') ); ?>"></button>
			</td>
			<td class="action">
				<a class="button alignright" href="admin.php?page=logtastic_settings&tab=js-error-log"><?php esc_html_e( 'Settings', 'logtastic' ); ?></a>
			</td>
		</tr>
		
	</tbody>
	
</table>