<?php
/**
 * The admin page to display the JS Error Log.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */
 
namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<?php $js_error_log_admin->display_table_search(); ?>

<div class="tablenav top">
	<?php if ( !empty ( $this->access_permissions ) && in_array( 'js-error-log-edit', $this->access_permissions ) ) { ?>
		<div class="alignleft actions bulkactions">
			<?php $js_error_log_admin->display_table_bulk_actions('top'); ?>
		</div>
	<?php } ?>
	<div class="alignleft actions">
		<?php $js_error_log_admin->display_table_filters(); ?>
	</div>
	<h2 class="screen-reader-text">
		<?php esc_html_e( 'Error log table navigation', 'logtastic' ); ?>
	</h2>
	<div class="tablenav-pages">
		<span class="displaying-num">
			<?php
				printf(
					esc_html(
						/* translators: %s: number of items found */
						_n(
							'%s item',
							'%s items',
							$js_error_log_admin->get_error_count(),
							'logtastic'
						)
					),
					esc_html( number_format_i18n( $js_error_log_admin->get_error_count() ) )
				);
			?>
		</span>
		<?php $js_error_log_admin->display_pagination( 'top' ); ?>
	</div>
	<br class="clear">
</div>

<table class="widefat view-log-table view-log-table-js-errors">
	
	<caption class="screen-reader-text">
		<?php
			printf(
				'%s %s. %s.',
				esc_html__( 'Table ordered by', 'logtastic' ),
				esc_html( $js_error_log_admin->sort_by_label ),
				esc_html( $js_error_log_admin->sort_order_label )
			)
		?>
	</caption>

	<thead>
		<tr>
			<td id="cb" class="manage-column column-cb check-column">
				<input id="cb-select-all-1" type="checkbox">
				<label for="cb-select-all-1">
					<span class="screen-reader-text"><?php esc_html_e( 'Select All', 'logtastic' ); ?></span>
				</label>
			</td>
			<th scope="col" id="error-type" class="manage-column column-error-type"><?php esc_html_e( 'Error Type', 'logtastic' ); ?></th>
			<th scope="col" id="error-source" class="manage-column column-error-source"><?php esc_html_e( 'Source', 'logtastic' ); ?></th>
			<th scope="col" id="error-detail" class="manage-column column-error-detail"><?php esc_html_e( 'Error', 'logtastic' ); ?></th>
			<th scope="col" id="error-count" class="align-right manage-column column-error-count <?php if ( 'occurrence_count' == $js_error_log_admin->sort_by ) { ?>sorted<?php } else { ?>sortable<?php } ?> <?php echo esc_attr( strtolower( $js_error_log_admin->sort_order ) ); ?>">
				<a href="<?php echo esc_url( $js_error_log_admin->get_count_column_header_url() ); ?>">
					<span><?php esc_html_e( 'Count', 'logtastic' ); ?></span>
					<span class="sorting-indicators">
						<span class="sorting-indicator asc" aria-hidden="true"></span>
						<span class="sorting-indicator desc" aria-hidden="true"></span>
					</span>
				</a>
			</th>
			<th scope="col" id="error-first" class="align-right manage-column column-error-first-occurred <?php if ( 'first_occurred' == $js_error_log_admin->sort_by ) { ?>sorted<?php } else { ?>sortable<?php } ?> <?php echo esc_attr( strtolower( $js_error_log_admin->sort_order ) ); ?>">
				<a href="<?php echo esc_url( $js_error_log_admin->get_first_occurred_column_header_url() ); ?>">
					<span><?php esc_html_e( 'First Occurred', 'logtastic' ); ?></span>
					<span class="sorting-indicators">
						<span class="sorting-indicator asc" aria-hidden="true"></span>
						<span class="sorting-indicator desc" aria-hidden="true"></span>
					</span>
				</a>
			</th>
			<th scope="col" id="error-last" class="align-right manage-column column-error-last-occurred <?php if ( 'last_occurred' == $js_error_log_admin->sort_by ) { ?>sorted<?php } else { ?>sortable<?php } ?> <?php echo esc_attr( strtolower( $js_error_log_admin->sort_order ) ); ?>">
				<a href="<?php echo esc_url( $js_error_log_admin->get_last_occurred_column_header_url() ); ?>">
					<span><?php esc_html_e( 'Last Occurred', 'logtastic' ); ?></span>
					<span class="sorting-indicators">
						<span class="sorting-indicator asc" aria-hidden="true"></span>
						<span class="sorting-indicator desc" aria-hidden="true"></span>
					</span>
				</a>
			</th>
		</tr>
	</thead>

	<tbody id="the-list">
		
		<?php if ( false !== $errors ) { ?>
		
			<?php foreach ( $errors as $error ) { ?>
		
				<tr id="error-<?php echo esc_attr( $error['error_id'] ); ?>">
					<th scope="row" class="check-column">
						<input id="cb-select-<?php echo esc_attr( $error['error_id'] ); ?>" type="checkbox" name="selected-error[]" value="<?php echo esc_attr( $error['error_id'] ); ?>">
						<label for="cb-select-<?php echo esc_attr( $error['error_id'] ); ?>">
							<span class="screen-reader-text"><?php esc_html_e( 'Select Error', 'logtastic' ); ?></span>
						</label>
					</th>
					<td class="error column-error-type has-label" data-colname="<?php esc_attr_e( 'Error Type', 'logtastic' ); ?>">
						<span class="error-level-label error-level-<?php echo esc_attr( $error['error_type'] ); ?>">
							<?php echo esc_html( Logtastic_JS_Error_Log_Admin::get_error_label( $error['error_type'] ) ); ?>
						</span>
					</td>
					<td class="error column-error-source has-label" data-colname="<?php esc_attr_e( 'Source', 'logtastic' ); ?>">
						<div class="source-label">
							<?php if ( 'plugin' == $error['source'] ) { ?>
								<span class="dashicons dashicons-admin-plugins source-icon"></span>
								<span class="source-text"><?php echo esc_html( $js_error_log_admin->get_plugin_name( $error['source_slug'] ) ); ?></span>
							<?php } else if ( 'theme' == $error['source'] ) { ?>
								<span class="dashicons dashicons-admin-appearance source-icon"></span>
								<span class="source-text"><?php echo esc_html( $js_error_log_admin->get_theme_name( $error['source_slug'] ) ); ?></span>
							<?php } else { ?>
								<span class="dashicons dashicons-wordpress source-icon"></span>
								<span class="source-text"><?php esc_html_e( 'WordPress Core', 'logtastic' ); ?></span>
							<?php } ?>
						</div>
					</td>
					<td class="error column-error-detail column-primary" data-colname="<?php esc_attr_e( 'Error', 'logtastic' ); ?>">
						<strong class="row-title"><?php Logtastic_JS_Error_Log_Admin::extract_and_display_error_title($error); ?></strong>
						<div class="file">
							<strong><?php esc_html_e( 'Source', 'logtastic' ); ?>:</strong> 
							<span><?php echo esc_html( $js_error_log_admin->trim_error_source_path( $error['file'] ) ); ?></span>
						</div>
						<div class="line-column">
							<strong><?php esc_html_e( 'Line', 'logtastic' ); ?>:</strong>
							<span><?php echo esc_html ( $error['line'] ); ?></span>
							<strong><?php esc_html_e( 'Column', 'logtastic' ); ?>:</strong>
							<span><?php echo esc_html ($error['col'] ); ?></span>
						</div>
						<div class="row-actions">
							<span class="edit">
								<a href="#" aria-label="<?php esc_attr_e( 'View Error Details', 'logtastic' ); ?>" onclick="logtasticViewJSErrorDetails(event)"><?php esc_html_e( 'View Error Details', 'logtastic' ); ?></a>
							</span>
							<?php if ( !empty ( $this->access_permissions ) && in_array( 'js-error-log-edit', $this->access_permissions ) ) { ?>
								&nbsp;&nbsp;|&nbsp;&nbsp;
								<span class="trash">
									<a href="#" class="submitdelete" aria-label="<?php esc_attr_e( 'Delete Error', 'logtastic' ); ?>" onclick="logtasticDeleteSingleJSError(event)"><?php esc_html_e( 'Delete Error', 'logtastic' ); ?></a>
								</span>
								&nbsp;&nbsp;|&nbsp;&nbsp;
								<span class="trash">
									<a href="#" class="submitdelete" aria-label="<?php esc_attr_e( 'Delete & Ignore Error', 'logtastic' ); ?>" onclick="logtasticIgnoreSingleJSError(event)"><?php esc_html_e( 'Delete & Ignore Error', 'logtastic' ); ?></a>
								</span>
							<?php } ?>
						</div>
					</td>
					<td class="align-right column-error-count" data-colname="<?php esc_attr_e( 'Occurrence Count', 'logtastic' ); ?>"><?php echo esc_html ( $error['occurrence_count'] ); ?></td>
					<td class="align-right column-error-first-occurred" data-colname="<?php esc_attr_e( 'First Occurred', 'logtastic' ); ?>">
						<?php echo esc_html ( $this->format_date( $error['first_occurred'] ) ); ?><br />
						<?php echo esc_html ( $this->format_time( $error['first_occurred'] ) ); ?>
					</td>
					<td class="align-right column-error-last-occurred" data-colname="<?php esc_attr_e( 'Last Occurred', 'logtastic' ); ?>">
						<?php echo esc_html ( $this->format_date( $error['last_occurred'] ) ); ?><br />
						<?php echo esc_html ( $this->format_time( $error['last_occurred'] ) ); ?>
					</td>
				</tr>
				
			<?php } ?>
			
		<?php } else { ?>
			
			<tr>
				<td colspan="7" class="no-errors">
					<?php esc_html_e( 'There are no errors to display', 'logtastic' ); ?>
				</td>
			</tr>	
			
		<?php } ?>	
		
	</tbody>

</table>

<div class="tablenav bottom">
	<?php if ( !empty ( $this->access_permissions ) && in_array( 'js-error-log-edit', $this->access_permissions ) ) { ?>
		<div class="alignleft actions bulkactions">
			<?php $js_error_log_admin->display_table_bulk_actions('bottom'); ?>
		</div>
	<?php } ?>
	<div class="tablenav-pages">
		<span class="displaying-num">
			<?php
				printf(
					esc_html(
						/* translators: %s: number of items found */
						_n(
							'%s item',
							'%s items',
							$js_error_log_admin->get_error_count(),
							'logtastic'
						)
					),
					esc_html( number_format_i18n( $js_error_log_admin->get_error_count() ) )
				);
			?>
		</span>
		<?php $js_error_log_admin->display_pagination( 'bottom' ); ?>
	</div>
	<br class="clear">
</div>

<?php if ( !empty ( $this->access_permissions ) && in_array( 'js-error-log-edit', $this->access_permissions ) ) { ?>
	<form id="action" action="" method="post">
		<input type="hidden" name="action" value="">
		<input type="hidden" name="error_ids" value="">
		<?php wp_nonce_field( 'error-log-action' ); ?>
	</form>
<?php } ?>

<!-- Error Details Modal -->
<?php if ( false !== $error_modals ) { ?>
	
	<?php $logtastic_total_errors = count($errors); ?>
	<?php $logtastic_iteration = 0; ?>

	<div class="details-modal">
		<div class="details-modal-background" onclick="logtasticCloseDetailsModal()"></div>
		
		<?php foreach ( $error_modals as $error ) { ?>
			<?php $logtastic_iteration++; ?>
			<!-- Foreach error -->
			<div class="details-modal-body" data-nav-order="<?php echo esc_attr( $logtastic_iteration ); ?>" data-error-id="<?php echo esc_attr( $error['error_id'] ); ?>" data-loaded="false" data-occurrence-count="<?php echo esc_attr( $error['occurrence_count'] ); ?>" data-error-source="<?php echo esc_attr( $error['source'] ); ?>" data-error-type="<?php echo esc_attr( $error['error_type'] ); ?>">
				<div class="details-modal-body-header">
					<?php if ( $logtastic_iteration <= $logtastic_total_errors ) { ?>
						<button class="left dashicons<?php if ( $logtastic_iteration == 1 ) { ?> disabled<?php } ?>"<?php if ( $logtastic_iteration == 1 ) { ?> disabled=""<?php } else { ?> onclick="logtasticNavigateJSErrorDetails( <?php echo esc_attr( $logtastic_iteration - 1 ); ?> )"<?php } ?>>
							<span class="screen-reader-text"><?php esc_html_e( 'Show previous error', 'logtastic' ); ?></span>
						</button>
						<button class="right dashicons<?php if ( $logtastic_iteration == $logtastic_total_errors ) { ?> disabled<?php } ?>"<?php if ( $logtastic_iteration == $logtastic_total_errors ) { ?> disabled=""<?php } else { ?> onclick="logtasticNavigateJSErrorDetails( <?php echo esc_attr( $logtastic_iteration + 1 ); ?> )"<?php } ?>>
							<span class="screen-reader-text"><?php esc_html_e( 'Show next error', 'logtastic' ); ?></span>
						</button>
					<?php } ?>
					<button class="close dashicons" onclick="logtasticCloseDetailsModal()">
						<span class="screen-reader-text"><?php esc_html_e( 'Close details dialog', 'logtastic' ); ?></span>
					</button>
				</div>
				<div class="details-modal-body-content">
					<div class="details-intro">
						<span class="error-level-label error-level-<?php echo esc_attr( $error['error_type'] ); ?>">
							<?php echo esc_html( Logtastic_JS_Error_Log_Admin::get_error_label( $error['error_type'] ) ); ?>
						</span>
						<h2>
							<?php Logtastic_JS_Error_Log_Admin::extract_and_display_error_title($error); ?>
						</h2>
						<div class="file">
							<strong><?php esc_html_e( 'Source', 'logtastic' ); ?>:</strong> 
							<span><?php echo esc_html( $js_error_log_admin->trim_error_source_path( $error['file'] ) ); ?></span>
						</div>
						<div class="line-column">
							<div>
								<strong><?php esc_html_e( 'Line', 'logtastic' ); ?>:</strong>
								<span><?php echo esc_html ( $error['line'] ); ?></span>
							</div>
							<div>
								<strong><?php esc_html_e( 'Column', 'logtastic' ); ?>:</strong>
								<span><?php echo esc_html ($error['col'] ); ?></span>
							</div>
						</div>
					</div>
					<div class="details-sidebar">
						<div class="sidebar-section source">
							<h4><?php esc_html_e( 'Source', 'logtastic' ); ?></h4>
							<div class="source-label">
								<?php if ( 'plugin' == $error['source'] ) { ?>
									<span class="dashicons dashicons-admin-plugins source-icon"></span>
									<span class="source-text">
										<strong><?php echo esc_html( $js_error_log_admin->get_plugin_name( $error['source_slug'] ) ); ?></strong><br/>
										<small class="source-version"></small>
									</span>
								<?php } else if ( 'theme' == $error['source'] ) { ?>
									<span class="dashicons dashicons-admin-appearance source-icon"></span>
									<span class="source-text">
										<strong><?php echo esc_html( $js_error_log_admin->get_theme_name( $error['source_slug'] ) ); ?></strong><br/>
										<small class="source-version"></small>
									</span>
								<?php } else { ?>
									<span class="dashicons dashicons-wordpress source-icon"></span>
									<span class="source-text">
										<strong><?php esc_html_e( 'WordPress Core', 'logtastic' ); ?></strong><br/>
										<small class="source-version"></small>
									</span>
								<?php } ?>
							</div>
						</div>
						<div class="sidebar-section occurrences">
							<h4><?php esc_html_e( 'Overview', 'logtastic' ); ?></h4>
							<div class="occurrences-chart">
								<div class="loading">
									<img src="<?php echo esc_url( LOGTASTIC_PLUGIN_DIR_URL );; ?>/admin/img/loader.gif" alt="Loading Icon" class="loading-icon sm" />
								</div>
								<div class="loaded">
									<canvas id="occurrence-chart-<?php echo esc_attr( $error['error_id'] ); ?>"></canvas>
								</div>
							</div>
							<p class="flex first-occurred">
								<strong><?php esc_html_e( 'First Occurred', 'logtastic' ); ?></strong>
								<span>
									<?php echo esc_html( $this->format_date( $error['first_occurred'] ) ); ?><br />
									<?php echo esc_html( $this->format_time( $error['first_occurred'] ) ); ?>
								</span>
							</p>
							<p class="flex last-occurred">
								<strong><?php esc_html_e( 'Last Occurred', 'logtastic' ); ?></strong>
								<span>
									<?php echo esc_html( $this->format_date( $error['last_occurred'] ) ); ?><br />
									<?php echo esc_html( $this->format_time( $error['last_occurred'] ) ); ?>
								</span>
							</p>
							<p class="flex total-occurrences">
								<strong><?php esc_html_e( 'Total Occurrences', 'logtastic' ); ?></strong>
								<span>
									<?php echo esc_html( $error['occurrence_count'] ); ?>
								</span>
							</p>
						</div>
						<div class="sidebar-section environment">
							<h4><?php esc_html_e( 'Environment', 'logtastic' ); ?></h4>
							<div class="loading">
								<img src="<?php echo esc_url( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/loader.gif" alt="Loading Icon" class="loading-icon sm" />
							</div>
							<div class="loaded">
								<p class="flex"><strong><?php esc_html_e( 'WordPress', 'logtastic' ); ?> <span class="wp-version-text"><?php esc_html_e( 'Version', 'logtastic' ); ?></span>: </strong><span class="wp-version-number"></span></p>
							</div>
						</div>
						<div class="sidebar-section share">
							<h4><?php esc_html_e( 'Share Error', 'logtastic' ); ?></h4>
							<div class="share-error-input-group">
								<input type="text" value="<?php  $js_error_log_admin->create_and_display_error_url( $error ); ?>" readonly />
								<button class="button copy" onclick="logtasticCopyPreviousSiblingInputToClipboard(event)"><span class="dashicons dashicons-clipboard" style="pointer-events: none;"></span></button>
							</div>
						</div>
					</div>
					<div class="details-main occurrences">
						<h4><?php esc_html_e( 'Occurrences', 'logtastic' ); ?></h4>
						<div class="tablenav top occurrences-table-navigation"></div>
						<div class="occurrences-table-wrapper">
							<div class="loading">
								<img src="<?php echo esc_attr( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/loader.gif" alt="Loading Icon" class="loading-icon sm" />
							</div>
							<table class="occurrences-table">
								<thead>
									<tr>
										<th><?php esc_html_e( 'Date / Time', 'logtastic' ); ?></th>
										<?php if ( 'plugin' == $error['source'] ) { ?>
											<th><?php esc_html_e( 'Plugin Version', 'logtastic' ); ?></th>
										<?php } else if ( 'theme' == $error['source'] ) { ?>
											<th><?php esc_html_e( 'Theme Version', 'logtastic' ); ?></th>
										<?php } ?>
										<th><?php esc_html_e( 'WP Version', 'logtastic' ); ?></th>
										<th><?php esc_html_e( 'User', 'logtastic' ); ?></th>
										<th><?php esc_html_e( 'Stack Trace', 'logtastic' ); ?></th>
										<th><?php esc_html_e( 'Session Info', 'logtastic' ); ?></th>
									</tr>
								</thead>
								<tbody>
									<!-- Rows will be populated here by JavaScript -->
								</tbody>
							</table>
						</div>
					</div>
					<div class="responsive share">
						<h4><?php esc_html_e( 'Share Error', 'logtastic' ); ?></h4>
						<div class="share-error-input-group">
							<input type="text" value="<?php  $js_error_log_admin->create_and_display_error_url( $error ); ?>" readonly />
							<button class="button copy" onclick="logtasticCopyPreviousSiblingInputToClipboard(event)"><span class="dashicons dashicons-clipboard" style="pointer-events: none;"></span></button>
						</div>
					</div>
				</div>
				<div class="details-modal-body-footer">
					<?php if ( !empty ( $this->access_permissions ) && in_array( 'js-error-log-edit', $this->access_permissions ) ) { ?>
						<button class="button button-delete" onclick="logtasticDeleteSingleJSError(event)"><?php esc_html_e( 'Delete Error', 'logtastic' ); ?></button>
						<button class="button button-delete" onclick="logtasticIgnoreSingleJSError(event)"><?php esc_html_e( 'Delete & Ignore Error', 'logtastic' ); ?></button>
					<?php } ?>
				</div>
			</div>
		<?php } ?>	
			
	</div>
	
	<div class="stack-trace-modal" data-wp-home-path="<?php echo esc_attr( get_home_path() ); ?>">
		
		<div class="stack-trace-modal-background" onclick="logtasticCloseStackTrace()"></div>
		
		<div class="stack-trace-modal-body">
			
			<div class="stack-trace-modal-body-header">
				<h3><?php esc_html_e( 'Stack Trace', 'logtastic' ); ?></h3>
				<button class="close dashicons" onclick="logtasticCloseStackTrace()">
					<span class="screen-reader-text"><?php esc_html_e( 'Close details dialog', 'logtastic' ); ?></span>
				</button>
			</div>
			
			<div class="stack-trace-body-loading">
				<img src="<?php echo esc_url( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/loader.gif" alt="Loading Icon" class="loading-icon sm" />
			</div>
		
			<div class="stack-trace-body-content">
				
				<div id="stack-trace-body-content-switcher">
					<a id="stack-trace-body-content-switcher-visual" onclick="logtasticSwitchStackTrace('visual')" href="#visual"><?php esc_html_e( 'Visual', 'logtastic' ); ?></a>
					<a id="stack-trace-body-content-switcher-raw" onclick="logtasticSwitchStackTrace('raw')" class="available" href="#raw"><?php esc_html_e( 'Raw', 'logtastic' ); ?></a>
				</div>
				
				<div id="stack-trace-body-content-raw">
					<pre><code></code></pre>
				</div>
				
				<div id="stack-trace-body-content-visual">
				</div>
				
			</div>
			
		</div>
		
	</div>

	<div class="session-info-modal additional-details-modal">
		
		<div class="additional-details-modal-background" onclick="logtasticCloseSessionInfo()"></div>
		
		<div class="additional-details-modal-body">
			
			<div class="additional-details-modal-body-header">
				<h3><?php esc_html_e( 'Session Info', 'logtastic' ); ?></h3>
				<button class="close dashicons" onclick="logtasticCloseSessionInfo()">
					<span class="screen-reader-text"><?php esc_html_e( 'Close details dialog', 'logtastic' ); ?></span>
				</button>
			</div>
			
			<div class="additional-details-modal-body-loading">
				<img src="<?php echo esc_url( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/loader.gif" alt="Loading Icon" class="loading-icon sm" />
			</div>
		
			<div class="additional-details-modal-body-content">
				
				<h4><?php esc_html_e( 'Url', 'logtastic' ); ?>:</h4>
				<span id="session-info-url"></span>

				<br/><br/>

				<h4><?php esc_html_e( 'User Agent', 'logtastic' ); ?>:</h4>
				<span id="session-info-user-agent"></span>

			</div>
			
		</div>
		
	</div>
	
<?php } ?>