<?php
/**
 * The admin home page.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */
 
namespace Inspired_Plugins\Logtastic;


// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


// Check if no logs are enabled
if ( !isset( $this->settings['enabled_logs'] ) || empty( array_filter( $this->settings['enabled_logs'] ) ) ) { 

	// Display notification with link to settings page
	Logtastic_Admin::admin_page_notice( 'info', __( 'No logs are currently enabled. Please visit the plugin settings page to enable logging on this WordPress site.', 'logtastic' ), true, false );

} else {

	?>

	<div class="enabled-logs">

		<?php if ( !empty( $this->settings['enabled_logs']['php-error-log'] ) && in_array( 'php-error-log-view', $this->access_permissions ) ) { ?>
			<div class="log php-error-log">

				<div class="logo">
					<img src="<?php echo esc_url( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/php-logo.svg" alt="PHP Logo" />
				</div>

				<div class="details">
					<div>
						<h3><?php esc_html_e( 'PHP Error Log', 'logtastic' ); ?></h3>
						<p><?php esc_html_e( 'The PHP Error Log captures all PHP errors encountered on your WordPress site.', 'logtastic' ); ?></p>
						<br>
					</div>
					<div>
						<a href="admin.php?page=logtastic_php-error-log" class="button button-primary"><?php esc_html_e( 'View Log', 'logtastic' ); ?></a> &nbsp; <a href="admin.php?page=logtastic_settings&tab=php-error-log" class="button"><?php esc_html_e( 'Log Settings', 'logtastic' ); ?></a>
					</div>
				</div>

			</div>
		<?php } ?>

		<?php if ( !empty( $this->settings['enabled_logs']['js-error-log'] ) && in_array( 'js-error-log-view', $this->access_permissions ) ) { ?>
			<div class="log js-error-log">

				<div class="logo">
					<img src="<?php echo esc_url( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/js-logo.png" alt="PHP Logo" />
				</div>

				<div class="details">
					<div>
						<h3><?php esc_html_e( 'JavaScript Error Log', 'logtastic' ); ?></h3>
						<p><?php esc_html_e( 'The JavaScript Error Log captures all JavaScript errors encountered on your WordPress site.', 'logtastic' ); ?></p>
						<br>
					</div>
					<div>
						<a href="admin.php?page=logtastic_js-error-log" class="button button-primary"><?php esc_html_e( 'View Log', 'logtastic' ); ?></a> &nbsp; <a href="admin.php?page=logtastic_settings&tab=js-error-log" class="button"><?php esc_html_e( 'Log Settings', 'logtastic' ); ?></a>
					</div>
				</div>

			</div>
		<?php } ?>

	</div>
	

<?php } ?>

<div class="plugin-home-links">

	<?php if ( in_array( 'plugin-settings', $this->access_permissions ) ) { ?>
		<a href="admin.php?page=logtastic_settings">
			<?php esc_html_e( 'Plugin Settings', 'logtastic' ); ?>
		</a>
	<?php } ?>

	<a href="admin.php?page=logtastic_help">
		<?php esc_html_e( 'Help & Support', 'logtastic' ); ?>
	</a>

</div>