<?php
/**
 * The admin help page.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */
 
namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<div class="support-features">
        
	<div class="support-feature faq">

		<div>	
			<h3><?php esc_html_e( 'Frequently Asked Questions', 'logtastic' ); ?></h3>
			<p><?php esc_html_e( 'Find answers to the most commonly asked questions.', 'logtastic' ); ?></p>
			<br>
		</div>

		<div>
			<a href="https://logtastic.net/support/faq/" target="_blank" class="button primary"><?php esc_html_e( 'View FAQs', 'logtastic' ); ?></a>
		</div>

	</div>

	<div class="support-feature docs">

		<div>
			<h3><?php esc_html_e( 'Plugin Documentation', 'logtastic' ); ?></h3>
			<p><?php esc_html_e( 'Extensive plugin documentation and video guides to get you up and running.', 'logtastic' ); ?></p>
			<br>
		</div>
		
		<div>
			<a href="https://logtastic.net/support/documentation/" target="_blank" class="button primary"><?php esc_html_e( 'View Documentation', 'logtastic' ); ?></a>
		</div>

	</div>

	<div class="support-feature contact">

		<div>	
			<h3><?php esc_html_e( 'Contact Support', 'logtastic' ); ?></h3>
			<p><?php esc_html_e( "Can't find the answer you're looking for?", 'logtastic' ); ?></p>
			<p><?php esc_html_e( 'Need to report a problem, or suggest a new feature?', 'logtastic' ); ?></p>
			<br>
		</div>

		<div>
			<a href="https://logtastic.net/support/contact/" target="_blank" class="button primary"><?php esc_html_e( 'Contact Us', 'logtastic' ); ?></a>
		</div>

	</div>

</div>