<?php
/**
 * The navigation tabs for the plugin settings pages.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */

namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<nav class="nav-tab-wrapper">
	<div class="nav-tab-group general-settings-tabs">
		<a href="admin.php?page=logtastic_settings" class="nav-tab<?php if ( $active_settings_tab == 'enable-disable-logs') { ?>  nav-tab-active<?php } ?>">
			<?php esc_html_e( 'Enable/Disable Logs', 'logtastic' ); ?>
		</a>
		<a href="admin.php?page=logtastic_settings&tab=general" class="nav-tab<?php if ( $active_settings_tab == 'general') { ?>  nav-tab-active<?php } ?>">
			<?php esc_html_e( 'General Settings', 'logtastic' ); ?>
		</a>
		<a href="admin.php?page=logtastic_settings&tab=security" class="nav-tab<?php if ( $active_settings_tab == 'security') { ?>  nav-tab-active<?php } ?>">
			<?php esc_html_e( 'Security & Visibility', 'logtastic' ); ?>
		</a>
	</div>
	<div class="nav-tab-group log-settings-tabs">
		<a href="admin.php?page=logtastic_settings&tab=php-error-log" data-log-id="php-error-log" class="nav-tab margin-left<?php if ( $active_settings_tab == 'php-error-log') { ?>  nav-tab-active<?php } ?><?php if ( ! empty( $this->settings['enabled_logs']['php-error-log'] ) ) { ?> enabled<?php } ?>">
			<?php esc_html_e( 'PHP Error Log', 'logtastic' ); ?>
		</a>
		<a href="admin.php?page=logtastic_settings&tab=js-error-log" data-log-id="js-error-log" class="nav-tab<?php if ( $active_settings_tab == 'js-error-log') { ?>  nav-tab-active<?php } ?><?php if ( ! empty( $this->settings['enabled_logs']['js-error-log'] ) ) { ?> enabled<?php } ?>">
			<?php esc_html_e( 'JS Error Log', 'logtastic' ); ?>
		</a>
	</div>
	<div class="nav-tab-group responsive-toggle">
		<button id="logtastic-admin-settings-nav-tabs-toggle" class="nav-tab margin-left" aria-label="<?php esc_attr_e( 'Toggle Menu', 'logtastic' );?>"></button>
	</div>
</nav>