<?php
/**
 * The header layout for the admin pages.
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */
 
namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<div class="logtastic-admin-header">
	<div class="logtastic-admin-header-top-row">
		<div class="logtastic-admin-header-title-section">
			<img src="<?php echo esc_url ( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/logtastic-icon-transparent.png" alt="Logtastic logo" class="logtastic-logo" />
			<h1><?php esc_html_e( 'Logtastic', 'logtastic' );?></h1>
		</div>
		<div class="logtastic-admin-header-brand-logo">
			<a href="https://inspiredplugins.com" target="_blank">
				<img src="<?php echo esc_url ( LOGTASTIC_PLUGIN_DIR_URL ); ?>/admin/img/inspired_plugins_logo.svg" alt="Inspired Plugins logo" class="inspired-logo-small" />
			</a>
		</div>
	</div>
	<nav class="logtastic-admin-header-nav-wrapper">
		<ul class="logtastic-admin-header-nav primary">
			<?php if ( !empty( $this->settings['enabled_logs']['php-error-log'] ) && in_array( 'php-error-log-view', $this->access_permissions ) ) { ?>
				<li>
					<a href="admin.php?page=logtastic_php-error-log" class="logtastic-admin-header-nav-item logtastic-admin-header-nav-item-php<?php if ( $plugin_page == 'logtastic_php-error-log' ) { ?> active<?php } ?>">
						<?php esc_html_e( 'PHP Error Log', 'logtastic' );?>
					</a>
				</li>
			<?php } ?>
			<?php if ( !empty( $this->settings['enabled_logs']['js-error-log'] ) && in_array( 'js-error-log-view', $this->access_permissions ) ) { ?>
				<li>
					<a href="admin.php?page=logtastic_js-error-log" class="logtastic-admin-header-nav-item logtastic-admin-header-nav-item-js<?php if ( $plugin_page == 'logtastic_js-error-log' ) { ?> active<?php } ?>">
						<?php esc_html_e( 'JS Error Log', 'logtastic' );?>
					</a>
				</li>
			<?php } ?>
		</ul>
		<ul class="logtastic-admin-header-nav secondary">
			<?php if ( in_array( 'plugin-settings', $this->access_permissions ) ) { ?>
				<li>
					<a href="admin.php?page=logtastic_settings" class="logtastic-admin-header-nav-item<?php if ( $plugin_page == 'logtastic_settings' ) { ?> active<?php } ?>">
						<?php esc_html_e( 'Settings', 'logtastic' );?>
						
					</a>
				</li>
			<?php } ?>	
			<li>
				<a href="admin.php?page=logtastic_help" class="logtastic-admin-header-nav-item<?php if ( $plugin_page == 'logtastic_help' ) { ?> active<?php } ?>">
					<?php esc_html_e( 'Help & Support', 'logtastic' );?>
				</a>
			</li>
		</ul>
		<button id="logtastic-admin-header-nav-toggle" aria-label="<?php esc_attr_e( 'Toggle Menu', 'logtastic' );?>"></button>
	</nav>
</div>

<div class="wrap">
	<h2 class="logtastic-admin-page-title"><?php echo esc_html( $title ); ?></h2>