<?php

/**
 * Functionality to determine the current user's access permissions
 *
 * @link              https://logtastic.net/
 * @since             1.0.0
 * @package           Logtastic
 * @subpackage        Logtastic/admin
 * @author            Inspired Plugins
 * @copyright         2025 Morley Digital Limited
 * @license           GPL-2.0-or-later
 */

namespace Inspired_Plugins\Logtastic;

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


class Logtastic_Admin_Access {

	static function define_access( $settings ) {

        // Create blank array to store plugin access permissions
        $access = [];

        // Get the current user
        $current_user = wp_get_current_user();

        // Get the current user's roles
        if ( $current_user->exists() ) {
            
            $current_user_roles = (array) $current_user->roles;
            
        }

        // If the current user's role is in the allowed access array defined in $settings, add access permissions to $access
        if ( !empty( $settings['access_roles'] ) && !empty( $current_user_roles ) && array_intersect( $settings['access_roles'], $current_user_roles ) ) {
            
            // PHP Error Log Permissions
            $access[] = 'php-error-log-view';
            $access[] = 'php-error-log-edit';

            // JS Error Log Permissions
            $access[] = 'js-error-log-view';
            $access[] = 'js-error-log-edit';

            // Plugin Settings Permissions
            $access[] = 'plugin-settings';

        }

        return $access;

    }

}