<?php
/*
* Plugin Name: LoginEase
* Description: Passwordless login via magic link directly on the native WordPress login form, without shortcode.
* Version: 1.0.0
* Requires at least: 6.0
* Requires PHP: 7.4
* Author: Killian Santos
* Author URI: https://killian-santos.com/
* License: GPL v2 or later
* License URI: https://www.gnu.org/licenses/gpl-2.0.html
* Text Domain: loginease
* Domain Path: /languages
*/
// Exit if accessed directly for security.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
// Include core class files for settings, login handling, and logging functionality.
require_once plugin_dir_path( __FILE__ ) . 'includes/class-settings.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/class-login.php';
require_once plugin_dir_path( __FILE__ ) . 'includes/class-logger.php';
// Initialize login-related hooks as early as possible during WordPress initialization.
add_action( 'init', [ 'LoginEase_Login', 'init_hooks' ], 1 );
// Register the LoginEase settings page and settings fields in the admin area.
add_action( 'admin_menu', [ 'LoginEase_Settings', 'add_admin_menu' ] );
add_action( 'admin_init', [ 'LoginEase_Settings', 'settings_init' ] );
// Add a hook on WordPress native 'wp_login' action to log normal password logins.
add_action( 'init', function() {
    add_action( 'wp_login', function( $user_login, $user ) {
        LoginEase_Logger::log( $user->ID, 'Password' );
    }, 10, 2 );
});
// Add user profile metaboxes to show login history both on users viewing their own profile and admins editing others.
add_action( 'show_user_profile', [ 'LoginEase_Logger', 'add_login_logs_metabox' ] );
add_action( 'edit_user_profile', [ 'LoginEase_Logger', 'add_login_logs_metabox' ] );
// Plugin activation hook
register_activation_hook( __FILE__, function() {
    global $wpdb;
    require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    $charset_collate = $wpdb->get_charset_collate();
    $table_tokens = $wpdb->prefix . 'loginease_tokens';
    $table_logs   = $wpdb->prefix . 'loginease_logs';
    $sql_tokens = "CREATE TABLE $table_tokens (
        id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        user_id bigint(20) unsigned NOT NULL,
        token varchar(255) NOT NULL,
        expire datetime NOT NULL,
        used tinyint(1) NOT NULL DEFAULT 0,
        PRIMARY KEY (id),
        UNIQUE KEY token (token),
        INDEX user_id (user_id),
        INDEX expire (expire)
    ) $charset_collate;";
    $sql_logs = "CREATE TABLE $table_logs (
        id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
        user_id bigint(20) unsigned NOT NULL,
        ip varchar(100) NOT NULL,
        date datetime NOT NULL,
        method varchar(20) NOT NULL DEFAULT 'Password',
        PRIMARY KEY (id),
        INDEX user_id (user_id),
        INDEX date (date)
    ) $charset_collate;";
    dbDelta( $sql_tokens );
    dbDelta( $sql_logs );
    flush_rewrite_rules();
});
// Plugin deactivation hook
register_deactivation_hook( __FILE__, function() {
    flush_rewrite_rules();
} );