<?php
/**
 * Uninstall routines for Login Security with Telegram Alerts plugin.
 *
 * This file is executed when the plugin is uninstalled (deleted from the WordPress admin).
 * It cleans up all database tables and options created by the plugin.
 *
 * @package Login_Security_Telegram_Alerts
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Ensure the necessary global variables are available.
global $wpdb;

// Define table names with proper escaping.
$lsec_table_failed_attempts = esc_sql( $wpdb->prefix . 'lsec_login_attempts' );
$lsec_table_all_activity    = esc_sql( $wpdb->prefix . 'lsec_all_login_activity' );
$lsec_table_user_devices    = esc_sql( $wpdb->prefix . 'lsec_user_devices' );

// Drop database tables.
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Schema change required during uninstall. Table names are properly escaped with esc_sql().
$wpdb->query( "DROP TABLE IF EXISTS `{$lsec_table_failed_attempts}`" );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Schema change required during uninstall. Table names are properly escaped with esc_sql().
$wpdb->query( "DROP TABLE IF EXISTS `{$lsec_table_all_activity}`" );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Schema change required during uninstall. Table names are properly escaped with esc_sql().
$wpdb->query( "DROP TABLE IF EXISTS `{$lsec_table_user_devices}`" );

// Delete plugin options.
$lsec_options_to_delete = [
    'lsec_max_attempts',
    'lsec_lockout_duration',
    'lsec_notify_roles',
    'lsec_enable_geolocation',
    'lsec_notify_on_failed_attempt',
    'lsec_notify_admin_on_lockout',
    'lsec_manual_blacklist_ips',
    'lsec_manual_whitelist_ips',
    'lsec_bot_token',
    'lsec_chat_id',
    'lsec_custom_admin_url',
    'lsec_max_devices_per_user',
    'lsec_notify_new_device_login', // Old option cleanup
];

foreach ( $lsec_options_to_delete as $lsec_option_name ) {
    delete_option( $lsec_option_name );
}

// Delete transients.
// It's good practice to delete transients related to your plugin.
// Since geolocation transients are dynamically named, we need to find them.
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Direct query required to find all plugin transients during uninstall. No caching needed for one-time cleanup operation.
$lsec_transients_to_delete = $wpdb->get_col( $wpdb->prepare( "SELECT option_name FROM `{$wpdb->options}` WHERE option_name LIKE %s", $wpdb->esc_like( '_transient_lsec_geo_' ) . '%' ) );
foreach ( $lsec_transients_to_delete as $lsec_transient ) {
    delete_transient( str_replace( '_transient_', '', $lsec_transient ) );
}

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Direct query required to find all plugin transient timeouts during uninstall. No caching needed for one-time cleanup operation.
$lsec_transient_timeouts_to_delete = $wpdb->get_col( $wpdb->prepare( "SELECT option_name FROM `{$wpdb->options}` WHERE option_name LIKE %s", $wpdb->esc_like( '_transient_timeout_lsec_geo_' ) . '%' ) );
foreach ( $lsec_transient_timeouts_to_delete as $lsec_transient_timeout ) {
    delete_option( $lsec_transient_timeout );
}