<?php
/**
 * Handles advanced security features: custom admin URL and device management.
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class LSEC_Advanced_Security {

    public function __construct() {
        // Custom admin URL hooks
        add_action('init', [$this, 'handle_custom_admin_url'], 1);
    }

    /**
     * Handles custom admin URL redirects and access control.
     */
    public function handle_custom_admin_url() {
        $custom_url = get_option('lsec_custom_admin_url', '');
        if (empty($custom_url)) {
            return; // Feature disabled
        }

        global $pagenow;
        $request_uri = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI'])) : '';

        // Get the current path without query string
        $current_path = strtok($request_uri, '?');
        $current_path = trim($current_path, '/');

        // Set cookie when accessing through custom URL
        if ($current_path === $custom_url) {
            if (!isset($_COOKIE['lsec_admin_access'])) {
                setcookie('lsec_admin_access', md5($custom_url . NONCE_SALT), time() + 3600, COOKIEPATH, COOKIE_DOMAIN, is_ssl(), true);
            }

            // Redirect to actual admin
            if (!is_user_logged_in()) {
                require_once ABSPATH . 'wp-login.php';
                exit;
            } else {
                // Set a flag to prevent redirect loops
                if (!defined('LSEC_ADMIN_REDIRECT')) {
                    define('LSEC_ADMIN_REDIRECT', true);
                    wp_safe_redirect(admin_url());
                    exit;
                }
            }
        }

        // Block direct wp-admin access (except for AJAX, admin-post, and logged-in users with cookie)
        if ((strpos($request_uri, '/wp-admin') !== false || strpos($request_uri, '/wp-login.php') !== false)
            && !defined('DOING_AJAX')
            && strpos($request_uri, 'admin-post.php') === false
        ) {
            // Check if user has access cookie from custom URL
            $has_access_cookie = isset($_COOKIE['lsec_admin_access']) && $_COOKIE['lsec_admin_access'] === md5($custom_url . NONCE_SALT);

            // Allow if user has valid access cookie
            if (!$has_access_cookie && !is_user_logged_in()) {
                // Redirect to 404
                global $wp_query;
                $wp_query->set_404();
                status_header(404);
                nocache_headers();
                include get_query_template('404');
                exit;
            }
        }
    }

}
