<?php
/**
 * The typography metabox file.
 *
 * @package Location_Weather
 */

if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access directly.
SPLW::createSection(
	'sp_location_weather_generator',
	array(
		'title'  => __( 'Typography', 'location-weather' ),
		'icon'   => '<span><svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="14px" height="14px" viewBox="0 0 448 512"><!-- Font Awesome Pro 5.15.3 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) --><path d="M432 432h-33.32l-135-389.24A16 16 0 0 0 248.55 32h-49.1a16 16 0 0 0-15.12 10.76L49.32 432H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-35.44l33.31-96h164.26l33.31 96H304a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM158.53 288L224 99.31 289.47 288z"/></svg></span>',
		'class'  => 'splw-weather-settings-meta-box',
		'fields' => array(
			array(
				'type'    => 'notice',
				'style'   => 'normal',
				'class'   => 'lw-typography-pro-notice',
				/* translators: %1$s: anchor tag start, %2$s: first anchor tag end,%3$s: second anchor tag start, %4$s: second anchor tag end. */
				'content' => sprintf( __( 'The following typography options are %1$sPremium features%2$s except for the, %3$sColor and Margin%4$s fields.', 'location-weather' ), ' <a href="https://locationweather.io/pricing/?ref=1" target="_blank"><b>', '</b></a>', '<span class="lw-text-color"><b>', '</b></span>' ),
			),
			array(
				'type'  => 'tabbed',
				'class' => 'lw-typography-tabs',
				'tabs'  => array(
					array(
						'title'  => __( 'Regional Preferences', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-regional-weather"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw-weather-title-font-load',
								'type'       => 'switcher',
								'title'      => __( 'Load Weather Section Title Font', 'location-weather' ),
								'subtitle'   => __( 'On/Off google font for the Section Title.', 'location-weather' ),
								'class'      => 'splw-first-fields splw_lite_pro_only',
								'default'    => false,
								'dependency' => array( 'lw-title', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-weather-title-typography',
								'type'       => 'typography',
								'class'      => 'lw-weather-title-typo pro_only_field',
								'title'      => __( 'Weather Section Title', 'location-weather' ),
								'default'    => array(
									'font-family'    => '',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'capitalize',
									'font-size'      => '27',
									'line-height'    => '28',
									'letter-spacing' => '0',
									'color'          => '#000',
									'margin-top'     => '0',
									'margin-bottom'  => '20',
								),
								'dependency' => array( 'lw-title', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-weather-title-color',
								'type'       => 'color',
								'title'      => __( 'Color', 'location-weather' ),
								'default'    => '#000',
								'dependency' => array( 'lw-title', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-weather-title-margin',
								'type'       => 'spacing',
								'class'      => 'lw-weather-title-margin',
								'title'      => __( 'Margin', 'location-weather' ),
								'all'        => false,
								'left'       => false,
								'right'      => false,
								'min'        => 0,
								'max'        => 100,
								'units'      => array( 'px' ),
								'default'    => array(
									'top'    => '0',
									'bottom' => '20',
								),
								'dependency' => array( 'lw-title', '==', 'true', true ),
							),
							array(
								'id'       => 'lw-city-name-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Location Name Font', 'location-weather' ),
								'subtitle' => __( 'On/Off google font for Location Name.', 'location-weather' ),
								'class'    => 'splw-first-fields splw_lite_pro_only',
								'default'  => false,
							),
							array(
								'id'      => 'lw-city-name-typography',
								'type'    => 'typography',
								'title'   => __( 'Location Name', 'location-weather' ),
								'class'   => 'lw-city-name-typo pro_only_field',
								'default' => array(
									'font-family'    => 'Roboto',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'none',
									'font-size'      => '27',
									'line-height'    => '38',
									'letter-spacing' => '0',
									'color'          => '#fff',
									'margin-top'     => '0',
									'margin-bottom'  => '4',
								),
							),
							array(
								'id'      => 'lw-city-name-color',
								'class'   => 'lw-city-name-color',
								'type'    => 'color',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
							array(
								'id'      => 'lw-city-name-margin',
								'type'    => 'spacing',
								'class'   => 'lw-city-name-margin',
								'title'   => __( 'Margin', 'location-weather' ),
								'all'     => false,
								'left'    => false,
								'right'   => false,
								'min'     => 0,
								'max'     => 100,
								'units'   => array( 'px' ),
								'default' => array(
									'top'    => '0',
									'bottom' => '10',
								),
							),
							array(
								'id'       => 'lw-date-time-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Date & Time Font', 'location-weather' ),
								'subtitle' => __( 'On/Off google font for Date & Time.', 'location-weather' ),
								'class'    => 'splw_lite_pro_only',
								'default'  => false,
							),
							array(
								'id'      => 'lw-date-time-typography',
								'type'    => 'typography',
								'title'   => __( 'Date (Time)', 'location-weather' ),
								'class'   => 'lw-date-time-typo pro_only_field',
								'default' => array(
									'font-family'    => 'Open Sans',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'none',
									'font-size'      => '14',
									'line-height'    => '0',
									'letter-spacing' => '0',
									'color'          => '#fff',
									'margin-top'     => '0',
									'margin-bottom'  => '10',
								),
							),
							array(
								'id'      => 'lw-date-time-color',
								'type'    => 'color',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
							array(
								'id'      => 'lw-date-time-margin',
								'type'    => 'spacing',
								'class'   => 'lw-date-time-margin',
								'title'   => __( 'Margin', 'location-weather' ),
								'all'     => false,
								'left'    => false,
								'right'   => false,
								'min'     => 0,
								'max'     => 100,
								'units'   => array( 'px' ),
								'default' => array(
									'top'    => '0',
									'bottom' => '10',
								),
							),
							array(
								'id'       => 'lw-tabs-title-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Tabs Title Font', 'location-weather' ),
								'subtitle' => __( 'On/Off google font for the tabs title.', 'location-weather' ),
								'default'  => false,
								'class'    => 'splw_lite_pro_only',
							),
							array(
								'id'            => 'lw-tabs-title-typography',
								'type'          => 'typography',
								'class'         => 'lw-tabs-title-typo pro_only_field_data',
								'title'         => __( 'Tabs Title', 'location-weather' ),
								'margin_bottom' => false,
								'margin_top'    => false,
								'text_align'    => false,
								'hover_color'   => true,
								'default'       => array(
									'font-family'    => '',
									'font-style'     => 'normal',
									'text-transform' => 'none',
									'font-size'      => '16',
									'line-height'    => '22',
									'letter-spacing' => '0',
									'color'          => '#fff',
									'hover-color'    => '#EA6A1D',
								),
							),
							array(
								'id'      => 'lw-tabs-title-color',
								'type'    => 'color_group',
								'class'   => 'lw-tabs-title-color splw_lite_pro_only',
								'title'   => __( 'Color', 'location-weather' ),
								'options' => array(
									'color'       => __( 'Color', 'location-weather' ),
									'hover-color' => __( 'Hover Color', 'location-weather' ),
								),
								'default' => array(
									'color'       => '#ffffff',
									'hover-color' => '#EA6A1D',
								),
							),
						),
					),
					array(
						'title'  => __( 'Current Weather', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-current-weather"></i></span>',
						'fields' => array(
							array(
								'id'       => 'lw-temp-scale-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Temperature & scale Font', 'location-weather' ),
								'class'    => 'splw_lite_pro_only',
								'subtitle' => __( 'On/Off google font for Temperature & scale.', 'location-weather' ),
								'default'  => false,
							),
							array(
								'id'          => 'lw-temp-scale-typography',
								'type'        => 'typography',
								'title'       => __( 'Temperature & scale', 'location-weather' ),
								'class'       => 'lw-temp-scale-typo pro_only_field',
								'default'     => array(
									'font-family'    => 'Roboto',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'none',
									'font-size'      => '48',
									'letter-spacing' => '0',
									'color'          => '#fff',
									'margin-top'     => '0',
									'margin-bottom'  => '0',
								),
								'line_height' => false,
							),
							array(
								'id'      => 'lw-temp-scale-color',
								'type'    => 'color',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
							array(
								'id'      => 'lw-temp-scale-margin',
								'type'    => 'spacing',
								'class'   => 'lw-temp-scale-margin',
								'title'   => __( 'Margin', 'location-weather' ),
								'all'     => false,
								'left'    => false,
								'right'   => false,
								'min'     => 0,
								'max'     => 100,
								'units'   => array( 'px' ),
								'default' => array(
									'top'    => '0',
									'bottom' => '0',
								),
							),
							array(
								'id'       => 'lw-high-low-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Highest & Lowest Temperature Font', 'location-weather' ),
								'class'    => 'splw_lite_pro_only',
								'subtitle' => __( 'On/Off google font for Highest & Lowest Temperature.', 'location-weather' ),
								'default'  => false,
							),
							array(
								'id'      => 'lw-highest-lowest-temp-typography',
								'type'    => 'typography',
								'title'   => __( 'Highest & Lowest Temperature ', 'location-weather' ),
								'class'   => 'pro_only_field_data',
								'default' => array(
									'font-family'    => 'Open Sans',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'none',
									'font-size'      => '14',
									'line-height'    => '0',
									'letter-spacing' => '0',
									'color'          => '#fff',
									'margin-top'     => '0',
									'margin-bottom'  => '0',
								),
							),
							array(
								'id'      => 'lw-highest-lowest-temp-color',
								'type'    => 'color',
								'class'   => 'splw_lite_pro_only',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
							array(
								'id'      => 'lw-highest-lowest-temp-margin',
								'type'    => 'spacing',
								'class'   => 'lw-highest-lowest-temp-margin splw_lite_pro_only',
								'title'   => __( 'Margin', 'location-weather' ),
								'all'     => false,
								'left'    => false,
								'right'   => false,
								'min'     => 0,
								'max'     => 100,
								'units'   => array( 'px' ),
								'default' => array(
									'top'    => '0',
									'bottom' => '0',
								),
							),
							array(
								'id'       => 'lw-real-feel-weather-desc-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Real Feel & Weather Description Font', 'location-weather' ),
								'subtitle' => __( 'On/Off google font for Real Feel & Weather Description.', 'location-weather' ),
								'class'    => 'splw_lite_pro_only',
								'default'  => false,
							),
							array(
								'id'      => 'lw-real-feel-weather-desc-typography',
								'type'    => 'typography',
								'title'   => __( 'Real Feel & Weather Description', 'location-weather' ),
								'class'   => 'lw-desc-typo pro_only_field',
								'default' => array(
									'font-family'    => 'Open Sans',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'capitalize',
									'font-size'      => '14',
									'line-height'    => '20',
									'letter-spacing' => '0',
									'color'          => '#fff',
									'margin-top'     => '10',
									'margin-bottom'  => '0',
								),
							),
							array(
								'id'      => 'lw-real-feel-weather-desc-color',
								'type'    => 'color',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
							array(
								'id'      => 'lw-real-feel-weather-desc-margin',
								'type'    => 'spacing',
								'class'   => 'weather-desc-margin',
								'title'   => __( 'Margin', 'location-weather' ),
								'all'     => false,
								'left'    => false,
								'right'   => false,
								'min'     => 0,
								'max'     => 100,
								'units'   => array( 'px' ),
								'default' => array(
									'top'    => '20',
									'bottom' => '0',
								),
							),
						),
					),
					array(
						'title'  => __( 'Additional Data', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-additional-data"></i></span>',
						'fields' => array(
							array(
								'id'       => 'lw-weather-units-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Weather Units Font', 'location-weather' ),
								'subtitle' => __( 'On/Off google font for Weather Units.', 'location-weather' ),
								'class'    => 'splw_lite_pro_only',
								'default'  => false,
							),
							array(
								'id'            => 'lw-weather-units-typography',
								'type'          => 'typography',
								'title'         => __( 'Weather Units', 'location-weather' ),
								'class'         => 'lw-weather-units-typo pro_only_field',
								'margin_top'    => false,
								'margin_bottom' => false,
								'default'       => array(
									'font-family'    => 'Open Sans',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'none',
									'font-size'      => '13',
									'line-height'    => '17',
									'letter-spacing' => '0',
									'color'          => '#fff',
								),
							),
							array(
								'id'      => 'lw-weather-units-color',
								'type'    => 'color',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
							array(
								'id'       => 'lw-weather-units-icons-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Weather Units( Pressure, Humidity, Wind ) Font', 'location-weather' ),
								'subtitle' => __( 'On/Off google font for Weather Units( Pressure, Humidity, Wind ).', 'location-weather' ),
								'class'    => 'splw_lite_pro_only',
								'default'  => false,
							),
							array(
								'id'         => 'lw-weather-units-icons-typography',
								'type'       => 'typography',
								'title'      => __( 'Weather Units( Pressure, Humidity, Wind )', 'location-weather' ),
								'text_align' => false,
								'class'      => 'pro_only_field',
								'default'    => array(
									'font-family'    => 'Open Sans',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'none',
									'font-size'      => '14',
									'line-height'    => '27',
									'letter-spacing' => '0',
									'color'          => '#fff',
									'margin-top'     => '16',
									'margin-bottom'  => '0',
								),
							),
							array(
								'id'      => 'lw-weather-units-icons-color',
								'type'    => 'color',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
							array(
								'id'      => 'lw-weather-units-icons-margin',
								'type'    => 'spacing',
								'class'   => 'weather-units-icons-margin',
								'title'   => __( 'Margin', 'location-weather' ),
								'all'     => false,
								'left'    => false,
								'right'   => false,
								'min'     => 0,
								'max'     => 100,
								'units'   => array( 'px' ),
								'default' => array(
									'top'    => '20',
									'bottom' => '0',
								),
							),
						),
					),
					array(
						'title'  => __( 'Forecast Data', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-forecast-data"></i></span>',
						'fields' => array(
							array(
								'id'       => 'lw-forecast-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Forecast Font', 'location-weather' ),
								'subtitle' => __( 'On/Off google font for Forecast.', 'location-weather' ),
								'class'    => 'splw_lite_pro_only',
								'default'  => false,
							),
							array(
								'id'         => 'lw-forecast-typography',
								'type'       => 'typography',
								'title'      => __( 'Forecast', 'location-weather' ),
								'text_align' => false,
								'class'      => 'lw-forecast-typo pro_only_field_data',
								'default'    => array(
									'font-family'    => 'Open Sans',
									'font-style'     => 'normal',
									'text-transform' => 'none',
									'font-size'      => '13',
									'letter-spacing' => '0',
									'color'          => '#fff',
									'margin-top'     => '0',
									'margin-bottom'  => '0',
								),
							),
							array(
								'id'      => 'lw-forecast-color',
								'type'    => 'color',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
							array(
								'id'      => 'lw-forecast-margin',
								'type'    => 'spacing',
								'title'   => __( 'Margin', 'location-weather' ),
								'all'     => false,
								'left'    => false,
								'right'   => false,
								'min'     => 0,
								'max'     => 100,
								'units'   => array( 'px' ),
								'default' => array(
									'top'    => '0',
									'bottom' => '0',
								),
							),
						),
					),
					array(
						'title'  => __( 'Footer', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-footer"></i></span>',
						'fields' => array(
							array(
								'id'       => 'lw-weather-attr-font-load',
								'type'     => 'switcher',
								'title'    => __( 'Load Weather Attribution Font', 'location-weather' ),
								'class'    => 'splw_lite_pro_only',
								'subtitle' => __( 'On/Off google font for Weather Attribution.', 'location-weather' ),
								'default'  => false,
							),
							array(
								'id'            => 'lw-weather-attr-typography',
								'type'          => 'typography',
								'title'         => __( 'Weather Attribution', 'location-weather' ),
								'class'         => 'pro_only_field',
								'margin_top'    => false,
								'margin_bottom' => false,
								'default'       => array(
									'font-family'    => 'Open Sans',
									'font-style'     => 'normal',
									'text-align'     => 'center',
									'text-transform' => 'none',
									'font-size'      => '11',
									'line-height'    => '26',
									'letter-spacing' => '0',
									'color'          => '#fff',
								),
							),
							array(
								'id'      => 'lw-weather-attr-color',
								'type'    => 'color',
								'title'   => __( 'Color', 'location-weather' ),
								'default' => '#fff',
							),
						),
					),
				),
			),
		),
	)
);
