<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LNH_Lunar_Calendar_Shortcode {
    
    public function __construct() {
        add_shortcode( 'lnh_lunar_calendar', [ $this, 'render_shortcode' ] );
    }

    public function render_shortcode( $atts ) {
        wp_enqueue_style('lnhlc-styles');
        wp_enqueue_script('lnhlc-script');

        $options = get_option( LNHLC_OPTIONS_NAME );
        $default_theme = !empty($options['default_theme']) ? $options['default_theme'] : 'light';

        $current_month = (int) wp_date('n');
        $current_year = (int) wp_date('Y');

        if ( isset( $_GET['lnhlc_nonce'] ) && wp_verify_nonce( sanitize_key( $_GET['lnhlc_nonce'] ), 'lnhlc_calendar_nav' ) ) {
            if ( isset( $_GET['lnhlc_month'] ) ) {
                $current_month = intval( $_GET['lnhlc_month'] );
            }
            if ( isset( $_GET['lnhlc_year'] ) ) {
                $current_year = intval( $_GET['lnhlc_year'] );
            }
        }

        $atts = shortcode_atts(
            [
                'layout' => 'widget',
                'theme'  => $default_theme,
                'month'  => $current_month,
                'year'   => $current_year,
            ],
            $atts,
            'lnh_lunar_calendar'
        );

        $layout = sanitize_key( $atts['layout'] );
        $cache_key_extra = ($layout === 'full') ? $atts['year'] . '_' . $atts['month'] : wp_date('Ymd');
        $options_hash = md5( serialize( get_option( LNHLC_OPTIONS_NAME ) ) );
$transient_key = 'lnhlc_cache_v' . LNHLC_VERSION . '_' . $options_hash . '_' . md5( serialize( $atts ) . $cache_key_extra );

        $output = get_transient( $transient_key );

        if ( false === $output ) {
            ob_start();
            
            $lunar_data = [];
            if ($layout === 'full') {
                $month_data = $this->get_full_month_data($atts['month'], $atts['year']);
                if (empty($month_data)) {
                    echo '<!-- LNH Lunar Calendar: Error generating full month data. -->';
                } else {
                    $lunar_data['month_data'] = $month_data;
                    $lunar_data['current_month'] = $atts['month'];
                    $lunar_data['current_year'] = $atts['year'];
                    // **NEW**: Get data for the current day to display in the header
                    $lunar_data['today_data'] = lnhlc_get_lunar_date_data();
                }
            } else {
                $lunar_data = lnhlc_get_lunar_date_data();
            }

            $theme = sanitize_key( $atts['theme'] );
            echo '<div class="lnhlc-container theme-' . esc_attr($theme) . ' layout-' . esc_attr($layout) . '">';
            $template_path = LNHLC_PLUGIN_DIR . "templates/layout-{$layout}.php";
            if ( file_exists( $template_path ) && !empty($lunar_data) ) {
                include $template_path;
            } else {
                $lunar_data = lnhlc_get_lunar_date_data();
                include LNHLC_PLUGIN_DIR . 'templates/layout-widget.php';
            }
            echo '</div>';
            $output = ob_get_clean();
            set_transient( $transient_key, $output, 3 * HOUR_IN_SECONDS );
        }
        return $output;
    }

    private function get_full_month_data($month, $year) {
        $calendar_data = [];
        $first_day_timestamp = mktime(0, 0, 0, $month, 1, $year);
        $first_day_of_week = (int)wp_date('N', $first_day_timestamp);
        $start_timestamp = $first_day_timestamp - (($first_day_of_week - 1) * 86400);
        $number_of_cells = 42;

        for ($i = 0; $i < $number_of_cells; $i++) {
            $current_timestamp = $start_timestamp + ($i * 86400);
            $day_data = lnhlc_get_lunar_date_data($current_timestamp);
            if ($day_data) {
                $day_data['is_current_month'] = ((int)wp_date('n', $current_timestamp) == $month);
                $calendar_data[] = $day_data;
            }
        }
        return $calendar_data;
    }
}
