<?php
/**
 * Template for the widget layout.
 * Variables available: $lunar_data, $atts
 */
if ( ! defined( 'ABSPATH' ) ) exit;
?>
<div class="lnhlc-widget" id="lnhlc-widget-display">
    <div class="lnhlc-header">
        <div class="lnhlc-weekday"><?php echo esc_html($lunar_data['weekday']); ?></div>
        <div class="lnhlc-solar-date">
            <span class="lnhlc-label"><?php echo esc_html(lnhlc_t('solar_date')); ?>:</span>
            <span><?php printf('%s/%s/%s', esc_html($lunar_data['solar_day']), esc_html($lunar_data['solar_month']), esc_html($lunar_data['solar_year'])); ?></span>
        </div>
    </div>
    <div class="lnhlc-body">
        <div class="lnhlc-lunar-day">
            <?php echo esc_html($lunar_data['lunar_day']); ?>
        </div>
        <div class="lnhlc-lunar-details">
            <div class="lnhlc-lunar-month-year">
                <?php echo esc_html(lnhlc_t('month')); ?> <?php echo esc_html($lunar_data['lunar_month']); ?>, <?php echo esc_html(lnhlc_t('year')); ?> <?php echo esc_html($lunar_data['can_chi_year']); ?>
            </div>
            <div class="lnhlc-lunar-can-chi">
                <?php 
                printf(
                    '%s: %s, %s: %s',
                    esc_html(lnhlc_t('day')), esc_html($lunar_data['can_chi_day']),
                    esc_html(lnhlc_t('month')), esc_html($lunar_data['can_chi_month']) // FIX: Corrected variable name from $luna_data to $lunar_data
                ); 
                ?>
            </div>
        </div>
    </div>
    <div class="lnhlc-footer">
        <strong><?php echo esc_html(lnhlc_t('zodiac_hours')); ?>:</strong>
        <span><?php echo esc_html($lunar_data['zodiac_hours_list']); ?></span>
    </div>
</div>
