<?php
/**
 * Template for the full month calendar layout.
 */
if ( ! defined( 'ABSPATH' ) ) exit;

$current_month = $lunar_data['current_month'];
$current_year = $lunar_data['current_year'];
$month_data = $lunar_data['month_data'];
$today_data = $lunar_data['today_data'];

$nonce = wp_create_nonce('lnhlc_calendar_nav');
$prev_month_ts = mktime(0, 0, 0, $current_month - 1, 1, $current_year);
$next_month_ts = mktime(0, 0, 0, $current_month + 1, 1, $current_year);
$weekdays = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
$today_day = (int)wp_date('j');
$today_month = (int)wp_date('n');
$today_year = (int)wp_date('Y');
?>
<div class="lnhlc-full" id="lnhlc-full-calendar" data-nonce="<?php echo esc_attr($nonce); ?>">
    
    <!-- Header section -->
    <div class="lnhlc-full-header" id="lnhlc-full-header-widget">
        <div class="header-col-1">
            <div class="header-weekday"><?php echo esc_html($today_data['weekday']); ?></div>
            <div class="header-solar-date">
                <?php echo esc_html(lnhlc_t('solar_date')); ?>: <?php printf('%s/%s/%s', esc_html($today_data['solar_day']), esc_html($today_data['solar_month']), esc_html($today_data['solar_year'])); ?>
            </div>
        </div>
        <div class="header-col-2">
            <div class="header-lunar-day">
    <?php echo esc_html( $today_data['lunar_day'] ); ?>
    <div class="header-lunar-label">
        <?php echo esc_html__( 'Âm lịch', 'lnh-lunar-calendar' ); ?>
    </div>
</div>

            <div class="header-lunar-details">
                <div class="header-lunar-my"><?php echo esc_html(lnhlc_t('month')); ?> <?php echo esc_html($today_data['lunar_month']); ?>, <?php echo esc_html(lnhlc_t('year')); ?> <?php echo esc_html($today_data['can_chi_year']); ?></div>
                <div class="header-lunar-cc"><?php echo esc_html(lnhlc_t('day')); ?>: <?php echo esc_html($today_data['can_chi_day']); ?>, <?php echo esc_html(lnhlc_t('month')); ?>: <?php echo esc_html($today_data['can_chi_month']); ?></div>
            </div>
        </div>
        <div class="header-col-3">
            <div class="header-zodiac"><?php echo esc_html(lnhlc_t('zodiac_hours')); ?>: <?php echo esc_html($today_data['zodiac_hours_list']); ?></div>
        </div>
    </div>

    <!-- Navigation section -->
    <div class="lnhlc-full-nav">
        <button type="button" class="nav-arrow prev" data-month="<?php echo esc_attr(wp_date('n', $prev_month_ts)); ?>" data-year="<?php echo esc_attr(wp_date('Y', $prev_month_ts)); ?>">&lt;</button>
        <div class="nav-title">Tháng <?php echo esc_html($current_month); ?> - <?php echo esc_html($current_year); ?></div>
        <button type="button" class="nav-arrow next" data-month="<?php echo esc_attr(wp_date('n', $next_month_ts)); ?>" data-year="<?php echo esc_attr(wp_date('Y', $next_month_ts)); ?>">&gt;</button>
        <div class="nav-form">
            <select name="lnhlc_month_select" id="lnhlc_month_select">
                <?php for ($m = 1; $m <= 12; $m++): ?>
                    <option value="<?php echo esc_attr($m); ?>" <?php selected($m, $current_month); ?>>Tháng <?php echo esc_html($m); ?></option>
                <?php endfor; ?>
            </select>
            <select name="lnhlc_year_select" id="lnhlc_year_select">
                <?php for ($y = 1940; $y <= 2099; $y++): ?>
                    <option value="<?php echo esc_attr($y); ?>" <?php selected($y, $current_year); ?>><?php echo esc_html($y); ?></option>
                <?php endfor; ?>
            </select>
            <button type="button" id="lnhlc_view_btn"><?php echo esc_html(lnhlc_t('view')); ?></button>
        </div>
    </div>

    <!-- Calendar Grid section -->
    <div class="lnhlc-full-grid">
        <?php foreach ($weekdays as $day): 
            $full_day_name = lnhlc_t($day);
            if ( function_exists('mb_substr') ) {
                $short_day_name = mb_substr($full_day_name, 0, 2, 'UTF-8');
            } else {
                $short_day_name = substr($full_day_name, 0, 2);
            }
        ?>
            <div class="grid-header">
                <span class="weekday-full"><?php echo esc_html($full_day_name); ?></span>
                <span class="weekday-short"><?php echo esc_html($short_day_name); ?></span>
            </div>
        <?php endforeach; ?>

        <?php foreach ($month_data as $day_data): 
            $classes = ['grid-day'];
            if (!$day_data['is_current_month']) {
                $classes[] = 'day-out-month';
            } else {
                $classes[] = 'day-in-month';
            }
            if ($day_data['solar_day'] == $today_day && $day_data['solar_month'] == $today_month && $day_data['solar_year'] == $today_year) {
                $classes[] = 'current-day';
            }
            if ($day_data['lunar_day'] === 1) $classes[] = 'is-lunar-first';
            if ($day_data['lunar_day'] === 15) $classes[] = 'is-lunar-fifteenth';
        ?>
            <div class="<?php echo esc_attr(implode(' ', $classes)); ?>"
                 data-sday="<?php echo esc_attr($day_data['solar_day']); ?>"
                 data-smonth="<?php echo esc_attr($day_data['solar_month']); ?>"
                 data-syear="<?php echo esc_attr($day_data['solar_year']); ?>"
                 data-weekday="<?php echo esc_attr($day_data['weekday']); ?>"
                 data-lday="<?php echo esc_attr($day_data['lunar_day']); ?>"
                 data-lmonth="<?php echo esc_attr($day_data['lunar_month']); ?>"
                 data-canchiday="<?php echo esc_attr($day_data['can_chi_day']); ?>"
                 data-canchimonth="<?php echo esc_attr($day_data['can_chi_month']); ?>"
                 data-canchyear="<?php echo esc_attr($day_data['can_chi_year']); ?>"
                 data-zodiac="<?php echo esc_attr($day_data['zodiac_hours_list']); ?>"
                 data-solardatelabel="<?php echo esc_attr(lnhlc_t('solar_date')); ?>"
                 data-daylabel="<?php echo esc_attr(lnhlc_t('day')); ?>"
                 data-monthlabel="<?php echo esc_attr(lnhlc_t('month')); ?>"
                 data-yearlabel="<?php echo esc_attr(lnhlc_t('year')); ?>"
                 data-zodiaclabel="<?php echo esc_attr(lnhlc_t('zodiac_hours')); ?>"
            >
                <div class="solar-day"><?php echo esc_html($day_data['solar_day']); ?></div>
                <div class="lunar-day-small">
                    <?php echo esc_html($day_data['lunar_day']); ?>/<?php echo esc_html($day_data['lunar_month']); ?>
                </div>
                <div class="can-chi-day"><?php echo esc_html($day_data['can_chi_day']); ?></div>
            </div>
        <?php endforeach; ?>
    </div>
</div>
