document.addEventListener('DOMContentLoaded', function() {
    const fullCalendarContainer = document.querySelector('#lnhlc-full-calendar');

    if (fullCalendarContainer) {
        const headerWidget = document.querySelector('#lnhlc-full-header-widget');
        
        if (headerWidget) {
            const days = fullCalendarContainer.querySelectorAll('.grid-day.day-in-month');
            let selectedDay = fullCalendarContainer.querySelector('.current-day');

            days.forEach(day => {
                day.addEventListener('click', function(e) {
                    e.preventDefault();
                    const data = this.dataset;

                    // Update header widget content using translated labels from data attributes
                    headerWidget.querySelector('.header-weekday').textContent = data.weekday;
                    headerWidget.querySelector('.header-solar-date').textContent = `${data.solardatelabel}: ${data.sday}/${data.smonth}/${data.syear}`;
                    headerWidget.querySelector('.header-lunar-day').textContent = data.lday;
                    headerWidget.querySelector('.header-lunar-my').textContent = `${data.monthlabel} ${data.lmonth}, ${data.yearlabel} ${data.canchyear}`;
                    headerWidget.querySelector('.header-lunar-cc').textContent = `${data.daylabel}: ${data.canchiday}, ${data.monthlabel}: ${data.canchimonth}`;
                    headerWidget.querySelector('.header-zodiac').textContent = `${data.zodiaclabel}: ${data.zodiac}`;

                    // Update selected day style
                    if (selectedDay) {
                        selectedDay.classList.remove('is-selected');
                    }
                    this.classList.add('is-selected');
                    selectedDay = this;
                });
            });
        }

        // Navigation Logic
        const navigateTo = (month, year) => {
            const url = new URL(window.location.href);
            const nonce = fullCalendarContainer.dataset.nonce;
            
            url.searchParams.set('lnhlc_month', month);
            url.searchParams.set('lnhlc_year', year);
            url.searchParams.set('lnhlc_nonce', nonce);

            window.location.href = url.href;
        };

        const viewBtn = document.getElementById('lnhlc_view_btn');
        if (viewBtn) {
            viewBtn.addEventListener('click', function() {
                const month = document.getElementById('lnhlc_month_select').value;
                const year = document.getElementById('lnhlc_year_select').value;
                navigateTo(month, year);
            });
        }

        fullCalendarContainer.querySelectorAll('.nav-arrow').forEach(arrow => {
            arrow.addEventListener('click', function() {
                const month = this.dataset.month;
                const year = this.dataset.year;
                navigateTo(month, year);
            });
        });
    }
});
